/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdLostException;
import me.ahoo.cosid.machine.MachineStateStorage;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;

public class GuardLost
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;

    public GuardLost(Supplier<MachineIdDistributor> implFactory) {
        this.implFactory = implFactory;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("GuardLost").generateAsString();
        InstanceId instanceId = MachineIdDistributorSpec.mockInstance(0, false);
        MachineStateStorage.IN_MEMORY.set(namespace, 5, instanceId);
        Assert.assertThrows(MachineIdLostException.class, () -> distributor.guard(namespace, instanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION));
    }
}

