/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeIdempotent
implements TestSpec {
    public static final Duration SAFE_GUARD_DURATION = Duration.ofSeconds(5L);
    private final Supplier<MachineIdDistributor> implFactory;

    public DistributeIdempotent(Supplier<MachineIdDistributor> implFactory) {
        this.implFactory = implFactory;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeSafeGuard").generateAsString();
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstances(5, false);
        MatcherAssert.assertThat(allInstances, (Matcher)Matchers.hasSize((int)MachineIdDistributor.totalMachineIds((int)5)));
        for (int i = 0; i < allInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, 5, allInstances.get(i), SAFE_GUARD_DURATION).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = MachineIdDistributorSpec.mockInstance(MachineIdDistributor.totalMachineIds((int)5), false);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, 5, overflowInstanceId, SAFE_GUARD_DURATION));
        for (int i = 0; i < allInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, 5, allInstances.get(i), SAFE_GUARD_DURATION).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
    }
}

