/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.util.List;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeStable
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;

    public DistributeStable(Supplier<MachineIdDistributor> implFactory) {
        this.implFactory = implFactory;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeStable").generateAsString();
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstances(5, true);
        MatcherAssert.assertThat(allInstances, (Matcher)Matchers.hasSize((int)MachineIdDistributor.totalMachineIds((int)5)));
        for (int i = 0; i < allInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, 5, allInstances.get(i), MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = InstanceId.of((String)"127.0.0.1", (int)MachineIdDistributor.totalMachineIds((int)5), (boolean)true);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, 5, overflowInstanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION));
        InstanceId firstInstanceId = allInstances.get(0);
        distributor.revert(namespace, firstInstanceId);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, 5, overflowInstanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION));
        int firstMachineId = distributor.distribute(namespace, 5, firstInstanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION).getMachineId();
        MatcherAssert.assertThat((Object)firstMachineId, (Matcher)Matchers.equalTo((Object)0));
    }
}

