/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeSafeGuard
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;
    private final int machineBit;
    private final Duration safeGuardDuration;

    public DistributeSafeGuard(Supplier<MachineIdDistributor> implFactory, int machineBit, Duration safeGuardDuration) {
        this.implFactory = implFactory;
        this.machineBit = machineBit;
        this.safeGuardDuration = safeGuardDuration;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeSafeGuard").generateAsString();
        int moreMachineBit = this.machineBit + 1;
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstances(moreMachineBit, false);
        int endIdx = MachineIdDistributor.totalMachineIds((int)this.machineBit);
        List<InstanceId> availableInstances = allInstances.subList(0, endIdx);
        MatcherAssert.assertThat(availableInstances, (Matcher)Matchers.hasSize((int)MachineIdDistributor.totalMachineIds((int)this.machineBit)));
        for (int i = 0; i < availableInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, this.machineBit, allInstances.get(i), this.safeGuardDuration).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = MachineIdDistributorSpec.mockInstance(MachineIdDistributor.totalMachineIds((int)this.machineBit), false);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, this.machineBit, overflowInstanceId, this.safeGuardDuration));
        LockSupport.parkNanos(this, this.safeGuardDuration.plusMillis(10L).toNanos());
        availableInstances = allInstances.subList(endIdx, MachineIdDistributor.totalMachineIds((int)moreMachineBit));
        Integer[] machineIds = (Integer[])availableInstances.stream().map(instanceId -> distributor.distribute(namespace, this.machineBit, instanceId, this.safeGuardDuration).getMachineId()).sorted().toArray(Integer[]::new);
        for (int i = 0; i < machineIds.length; ++i) {
            MatcherAssert.assertThat((Object)machineIds[i], (Matcher)Matchers.equalTo((Object)i));
        }
    }
}

