/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeConcurrent
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;
    private final int machineBit;

    public DistributeConcurrent(Supplier<MachineIdDistributor> implFactory, int machineBit) {
        this.implFactory = implFactory;
        this.machineBit = machineBit;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        int totalMachineIds = MachineIdDistributor.totalMachineIds((int)this.machineBit);
        CompletableFuture[] results = new CompletableFuture[totalMachineIds];
        String namespace = MockIdGenerator.usePrefix("DistributeConcurrent").generateAsString();
        for (int i = 0; i < totalMachineIds; ++i) {
            InstanceId instanceId = MachineIdDistributorSpec.mockInstance(i, false);
            results[i] = CompletableFuture.supplyAsync(() -> distributor.distribute(namespace, this.machineBit, instanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION).getMachineId());
        }
        CompletableFuture.allOf(results).join();
        Integer[] machineIds = (Integer[])Arrays.stream(results).map(CompletableFuture::join).sorted().toArray(Integer[]::new);
        for (int i = 0; i < machineIds.length; ++i) {
            MatcherAssert.assertThat((Object)machineIds[i], (Matcher)Matchers.equalTo((Object)i));
        }
    }
}

