/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeIdempotent
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;
    private final int machineBit;
    private final Duration safeGuardDuration;

    public DistributeIdempotent(Supplier<MachineIdDistributor> implFactory, int machineBit, Duration safeGuardDuration) {
        this.implFactory = implFactory;
        this.machineBit = machineBit;
        this.safeGuardDuration = safeGuardDuration;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeSafeGuard").generateAsString();
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstances(this.machineBit, false);
        MatcherAssert.assertThat(allInstances, (Matcher)Matchers.hasSize((int)MachineIdDistributor.totalMachineIds((int)this.machineBit)));
        for (int i = 0; i < allInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, this.machineBit, allInstances.get(i), this.safeGuardDuration).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = MachineIdDistributorSpec.mockInstance(MachineIdDistributor.totalMachineIds((int)this.machineBit), false);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, this.machineBit, overflowInstanceId, this.safeGuardDuration));
        for (int i = 0; i < allInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, this.machineBit, allInstances.get(i), this.safeGuardDuration).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
    }
}

