/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.ahoo.cosky.discovery.NamespacedServiceInstance;
import me.ahoo.cosky.discovery.RenewProperties;
import me.ahoo.cosky.discovery.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenewInstanceService {
    private static final Logger log = LoggerFactory.getLogger(RenewInstanceService.class);
    private volatile boolean running;
    private final RenewProperties renewProperties;
    private final ServiceRegistry serviceRegistry;
    private final ScheduledExecutorService scheduledExecutorService;
    private final AtomicInteger renewCounter = new AtomicInteger();

    public RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry) {
        this(renewProperties, serviceRegistry, new ScheduledThreadPoolExecutor(1, RenewInstanceService.createThreadFactory()));
    }

    public RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry, ScheduledExecutorService scheduledExecutorService) {
        this.renewProperties = renewProperties;
        this.serviceRegistry = serviceRegistry;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("start.");
        }
        this.running = true;
        this.scheduledExecutorService.scheduleAtFixedRate(this::renew, this.renewProperties.getInitialDelay(), this.renewProperties.getPeriod(), TimeUnit.SECONDS);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("stop.");
        }
        this.running = false;
        this.scheduledExecutorService.shutdown();
    }

    private void renew() {
        int times = this.renewCounter.incrementAndGet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        Set<NamespacedServiceInstance> instances = this.serviceRegistry.getRegisteredEphemeralInstances();
        if (log.isDebugEnabled()) {
            log.debug("renew - instances size:{} start - times@[{}] .", (Object)instances.size(), (Object)times);
        }
        if (instances.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("renew - instances size:{} end - times@[{}] .", (Object)instances.size(), (Object)times);
            }
            return;
        }
        CompletableFuture[] renewFutures = new CompletableFuture[instances.size()];
        Iterator<NamespacedServiceInstance> instanceIterator = instances.iterator();
        for (int i = 0; i < renewFutures.length; ++i) {
            NamespacedServiceInstance namespacedServiceInstance = instanceIterator.next();
            renewFutures[i] = this.serviceRegistry.renew(namespacedServiceInstance.getNamespace(), namespacedServiceInstance.getServiceInstance()).exceptionally(ex -> {
                if (log.isWarnEnabled()) {
                    log.warn("renew - failed.", ex);
                }
                return Boolean.FALSE;
            });
        }
        CompletableFuture.allOf(renewFutures).thenAccept(nil -> {
            if (log.isDebugEnabled()) {
                log.debug("renew - instances size:{} start - times@[{}] taken:[{}ms].", new Object[]{instances.size(), times, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            }
        });
    }

    private static ThreadFactory createThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat(RenewInstanceService.class.getSimpleName() + "-%d").setDaemon(true).build();
    }
}

