/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceChangedListener;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import me.ahoo.cosky.discovery.redis.ConsistencyRedisServiceDiscovery;

public abstract class AbstractLoadBalancer<Chooser extends LoadBalancer.Chooser>
implements LoadBalancer {
    private final ConcurrentHashMap<NamespacedServiceId, CompletableFuture<Chooser>> serviceMapChooser;
    private final ConsistencyRedisServiceDiscovery serviceDiscovery;

    public AbstractLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        this.serviceMapChooser = new ConcurrentHashMap();
    }

    @Override
    public CompletableFuture<ServiceInstance> choose(String namespace, String serviceId) {
        return this.serviceMapChooser.computeIfAbsent(NamespacedServiceId.of(namespace, serviceId), namespacedServiceId -> {
            this.serviceDiscovery.addListener((NamespacedServiceId)namespacedServiceId, new Listener());
            return this.serviceDiscovery.getInstances(namespace, serviceId).thenApply(serviceInstances -> this.createChooser((List<ServiceInstance>)serviceInstances));
        }).thenApply(chooser -> chooser.choose());
    }

    protected abstract Chooser createChooser(List<ServiceInstance> var1);

    private class Listener
    implements ServiceChangedListener {
        private Listener() {
        }

        @Override
        public void onChange(NamespacedServiceId namespacedServiceId, String op) {
            AbstractLoadBalancer.this.serviceMapChooser.computeIfPresent(namespacedServiceId, (key, value) -> AbstractLoadBalancer.this.serviceDiscovery.getInstances(namespacedServiceId.getNamespace(), namespacedServiceId.getServiceId()).thenApply(serviceInstances -> AbstractLoadBalancer.this.createChooser((List<ServiceInstance>)serviceInstances)));
        }
    }
}

