/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import com.google.common.base.Strings;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosky.core.NamespacedContext;
import me.ahoo.cosky.discovery.InstanceIdGenerator;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.RegistryProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceCodec;
import me.ahoo.cosky.discovery.ServiceRegistry;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceRegistry.class);
    private final RegistryProperties registryProperties;
    private final RedisClusterAsyncCommands<String, String> redisCommands;
    private final ConcurrentHashMap<NamespacedInstanceId, ServiceInstance> registeredEphemeralInstances = new ConcurrentHashMap();

    public RedisServiceRegistry(RegistryProperties registryProperties, RedisClusterAsyncCommands<String, String> redisCommands) {
        this.registryProperties = registryProperties;
        this.redisCommands = redisCommands;
    }

    private RedisFuture<Boolean> register0(String namespace, String scriptSha, ServiceInstance serviceInstance) {
        Object[] keys = new String[]{namespace};
        String[] infoArgs = new String[]{serviceInstance.isEphemeral() ? String.valueOf(this.registryProperties.getInstanceTtl()) : "-1", serviceInstance.getServiceId(), serviceInstance.getInstanceId(), serviceInstance.getSchema(), serviceInstance.getHost(), String.valueOf(serviceInstance.getPort()), String.valueOf(serviceInstance.getWeight())};
        Object[] values = ServiceInstanceCodec.encodeMetadata(infoArgs, serviceInstance.getMetadata());
        return this.redisCommands.evalsha(scriptSha, ScriptOutputType.BOOLEAN, keys, values);
    }

    @Override
    public CompletableFuture<Boolean> setService(String namespace, String serviceId) {
        if (log.isInfoEnabled()) {
            log.info("setService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.doRegistrySetService(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}));
    }

    @Override
    public CompletableFuture<Boolean> removeService(String namespace, String serviceId) {
        if (log.isWarnEnabled()) {
            log.warn("removeService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.doRegistryRemoveService(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}));
    }

    @Override
    public CompletableFuture<Boolean> register(ServiceInstance serviceInstance) {
        return this.register(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> register(String namespace, ServiceInstance serviceInstance) {
        this.ensureInstanceId(serviceInstance);
        if (log.isInfoEnabled()) {
            log.info("register - instanceId:[{}]  @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.addEphemeralInstance(namespace, serviceInstance);
        return DiscoveryRedisScripts.doRegistryRegister(this.redisCommands, sha -> this.register0(namespace, (String)sha, serviceInstance));
    }

    private void ensureInstanceId(ServiceInstance serviceInstance) {
        if (Strings.isNullOrEmpty((String)serviceInstance.getInstanceId())) {
            serviceInstance.setInstanceId(InstanceIdGenerator.DEFAULT.generate(serviceInstance));
        }
    }

    private void addEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.put(NamespacedInstanceId.of(namespace, serviceInstance.getInstanceId()), serviceInstance);
    }

    private void removeEphemeralInstance(String namespace, String instanceId) {
        this.registeredEphemeralInstances.remove(NamespacedInstanceId.of(namespace, instanceId));
    }

    private void removeEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.remove(NamespacedInstanceId.of(namespace, serviceInstance.getInstanceId()));
    }

    @Override
    public Map<NamespacedInstanceId, ServiceInstance> getRegisteredEphemeralInstances() {
        return this.registeredEphemeralInstances;
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, String key, String value) {
        return this.setMetadata(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId, key, value);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String namespace, String serviceId, String instanceId, String key, String value) {
        String[] values = new String[]{instanceId, key, value};
        return this.setMetadata0(namespace, instanceId, values);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String serviceId, String instanceId, Map<String, String> metadata) {
        return this.setMetadata(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId, metadata);
    }

    @Override
    public CompletableFuture<Boolean> setMetadata(String namespace, String serviceId, String instanceId, Map<String, String> metadata) {
        String[] values = ServiceInstanceCodec.encodeMetadata(new String[]{instanceId}, metadata);
        return this.setMetadata0(namespace, instanceId, values);
    }

    private CompletableFuture<Boolean> setMetadata0(String namespace, String instanceId, String[] args) {
        if (log.isInfoEnabled()) {
            log.info("setMetadata - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        String[] keys = new String[]{namespace};
        return DiscoveryRedisScripts.doRegistrySetMetadata(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])keys, (Object[])args));
    }

    @Override
    public CompletableFuture<Boolean> renew(ServiceInstance serviceInstance) {
        return this.renew(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> renew(String namespace, ServiceInstance serviceInstance) {
        if (log.isDebugEnabled()) {
            log.debug("renew - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        if (!serviceInstance.isEphemeral()) {
            if (log.isWarnEnabled()) {
                log.warn("renew - instanceId:[{}] @ namespace:[{}] is not ephemeral, can not renew.", (Object)serviceInstance.getInstanceId(), (Object)namespace);
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        String[] keys = new String[]{namespace};
        String[] values = new String[]{serviceInstance.getInstanceId(), String.valueOf(this.registryProperties.getInstanceTtl())};
        return DiscoveryRedisScripts.doRegistryRenew(this.redisCommands, sha -> {
            RedisFuture statusFuture = this.redisCommands.evalsha(sha, ScriptOutputType.INTEGER, (Object[])keys, (Object[])values);
            return statusFuture;
        }).thenCompose(status -> {
            if (status <= 0L) {
                if (log.isWarnEnabled()) {
                    log.warn("renew - instanceId:[{}] @ namespace:[{}] status is [{}],register again.", new Object[]{serviceInstance.getInstanceId(), namespace, status});
                }
                return this.register(namespace, serviceInstance);
            }
            return CompletableFuture.completedFuture(Boolean.TRUE);
        });
    }

    @Override
    public CompletableFuture<Boolean> deregister(String serviceId, String instanceId) {
        return this.deregister(NamespacedContext.GLOBAL.getNamespace(), serviceId, instanceId);
    }

    @Override
    public CompletableFuture<Boolean> deregister(String namespace, String serviceId, String instanceId) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, instanceId);
        return this.deregister0(namespace, serviceId, instanceId);
    }

    private CompletableFuture<Boolean> deregister0(String namespace, String serviceId, String instanceId) {
        return DiscoveryRedisScripts.doRegistryDeregister(this.redisCommands, sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId, instanceId};
            return this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values);
        });
    }

    @Override
    public CompletableFuture<Boolean> deregister(ServiceInstance serviceInstance) {
        return this.deregister(NamespacedContext.GLOBAL.getNamespace(), serviceInstance);
    }

    @Override
    public CompletableFuture<Boolean> deregister(String namespace, ServiceInstance serviceInstance) {
        this.ensureInstanceId(serviceInstance);
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, serviceInstance);
        return this.deregister0(namespace, serviceInstance.getServiceId(), serviceInstance.getInstanceId());
    }
}

