/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import me.ahoo.cosky.core.NamespacedContext;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceCodec;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceDiscovery.class);
    private final RedisClusterAsyncCommands<String, String> redisCommands;

    public RedisServiceDiscovery(RedisClusterAsyncCommands<String, String> redisCommands) {
        this.redisCommands = redisCommands;
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String serviceId) {
        return this.getInstances(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceId);
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String namespace, String serviceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        return DiscoveryRedisScripts.doDiscoveryGetInstances(this.redisCommands, sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId};
            return this.redisCommands.evalsha(sha, ScriptOutputType.MULTI, keys, values);
        }).thenApply(instanceGroups -> {
            if (Objects.isNull(instanceGroups)) {
                return Collections.emptyList();
            }
            ArrayList instances = new ArrayList(instanceGroups.size());
            instanceGroups.forEach(instanceData -> instances.add(ServiceInstanceCodec.decode(instanceData)));
            return instances;
        });
    }

    @Override
    public CompletableFuture<ServiceInstance> getInstance(String namespace, String serviceId, String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId can not be empty!");
        return DiscoveryRedisScripts.doDiscoveryGetInstance(this.redisCommands, sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId, instanceId};
            return this.redisCommands.evalsha(sha, ScriptOutputType.MULTI, keys, values);
        }).thenApply(instanceData -> {
            if (Objects.isNull(instanceData)) {
                return null;
            }
            return ServiceInstanceCodec.decode(instanceData);
        });
    }

    @Override
    public CompletableFuture<Long> getInstanceTtl(String namespace, String serviceId, String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId can not be empty!");
        return DiscoveryRedisScripts.doDiscoveryGetInstanceTtl(this.redisCommands, sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId, instanceId};
            return this.redisCommands.evalsha(sha, ScriptOutputType.INTEGER, keys, values);
        });
    }

    @Override
    public CompletableFuture<Set<String>> getServices(String namespace) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        String serviceIdxKey = DiscoveryKeyGenerator.getServiceIdxKey(namespace);
        return this.redisCommands.smembers((Object)serviceIdxKey).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Set<String>> getServices() {
        return this.getServices(NamespacedContext.GLOBAL.getRequiredNamespace());
    }
}

