/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.concurrent.CopyOnWriteArraySet;
import me.ahoo.cosky.core.Namespaced;
import me.ahoo.cosky.core.NamespacedContext;
import me.ahoo.cosky.discovery.ServiceInstance;

public interface ServiceInstanceContext
extends Namespaced {
    public static final ServiceInstanceContext CURRENT = new CurrentContext();

    public void setServiceInstance(ServiceInstance var1);

    public void addListener(ServiceInstanceContextChangedListener var1);

    public void removeListener(ServiceInstanceContextChangedListener var1);

    public ServiceInstance getServiceInstance();

    @FunctionalInterface
    public static interface ServiceInstanceContextChangedListener {
        public void onChange(ServiceInstance var1, ServiceInstance var2);
    }

    public static class CurrentContext
    implements ServiceInstanceContext {
        private volatile ServiceInstance serviceInstance;
        private final CopyOnWriteArraySet<ServiceInstanceContextChangedListener> listeners = new CopyOnWriteArraySet();

        public String getNamespace() {
            return NamespacedContext.GLOBAL.getNamespace();
        }

        @Override
        public void setServiceInstance(ServiceInstance serviceInstance) {
            ServiceInstance before = this.serviceInstance;
            this.serviceInstance = serviceInstance;
            this.listeners.forEach(changedListener -> changedListener.onChange(before, serviceInstance));
        }

        @Override
        public void addListener(ServiceInstanceContextChangedListener changedListener) {
            this.listeners.add(changedListener);
        }

        @Override
        public void removeListener(ServiceInstanceContextChangedListener changedListener) {
            this.listeners.remove(changedListener);
        }

        @Override
        public ServiceInstance getServiceInstance() {
            return this.serviceInstance;
        }
    }
}

