/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceContext;

public interface ServiceTopology {
    public static final String DEFAULT_CONSUMER_NAME = "_Client_";

    public CompletableFuture<Void> addTopology(String var1, String var2);

    public static String getConsumerName() {
        ServiceInstance consumerServiceInstance = ServiceInstanceContext.CURRENT.getServiceInstance();
        if (Objects.isNull(consumerServiceInstance)) {
            return DEFAULT_CONSUMER_NAME;
        }
        return consumerServiceInstance.getServiceId();
    }

    public static String getProducerName(String producerNamespace, String producerServiceId) {
        String consumerNamespace = ServiceInstanceContext.CURRENT.getNamespace();
        if (producerNamespace.equals(consumerNamespace)) {
            return producerServiceId;
        }
        return producerNamespace + "." + producerServiceId;
    }
}

