/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosky.discovery.InstanceIdGenerator;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.RegistryProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceCodec;
import me.ahoo.cosky.discovery.ServiceRegistry;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RedisServiceRegistry
implements ServiceRegistry {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceRegistry.class);
    private final RegistryProperties registryProperties;
    private final RedisClusterReactiveCommands<String, String> redisCommands;
    private final ConcurrentHashMap<NamespacedInstanceId, ServiceInstance> registeredEphemeralInstances = new ConcurrentHashMap();

    public RedisServiceRegistry(RegistryProperties registryProperties, RedisClusterReactiveCommands<String, String> redisCommands) {
        this.registryProperties = registryProperties;
        this.redisCommands = redisCommands;
    }

    private Mono<Boolean> register0(String namespace, String scriptSha, ServiceInstance serviceInstance) {
        Object[] keys = new String[]{namespace};
        String[] infoArgs = new String[]{serviceInstance.isEphemeral() ? String.valueOf(this.registryProperties.getInstanceTtl()) : "-1", serviceInstance.getServiceId(), serviceInstance.getInstanceId(), serviceInstance.getSchema(), serviceInstance.getHost(), String.valueOf(serviceInstance.getPort()), String.valueOf(serviceInstance.getWeight())};
        Object[] values = ServiceInstanceCodec.encodeMetadata(infoArgs, serviceInstance.getMetadata());
        return this.redisCommands.evalsha(scriptSha, ScriptOutputType.BOOLEAN, keys, values).map(result -> (Boolean)result).next();
    }

    @Override
    public Mono<Boolean> setService(String namespace, String serviceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        if (log.isInfoEnabled()) {
            log.info("setService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.doRegistrySetService(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}).cast(Boolean.class).next());
    }

    @Override
    public Mono<Boolean> removeService(String namespace, String serviceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        if (log.isWarnEnabled()) {
            log.warn("removeService - serviceId:[{}]  @ namespace:[{}].", (Object)serviceId, (Object)namespace);
        }
        return DiscoveryRedisScripts.doRegistryRemoveService(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])new String[]{namespace}, (Object[])new String[]{serviceId}).cast(Boolean.class).next());
    }

    @Override
    public Mono<Boolean> register(String namespace, ServiceInstance serviceInstance) {
        this.ensureNamespacedInstance(namespace, serviceInstance);
        this.ensureInstanceId(serviceInstance);
        if (log.isInfoEnabled()) {
            log.info("register - instanceId:[{}]  @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.addEphemeralInstance(namespace, serviceInstance);
        return DiscoveryRedisScripts.doRegistryRegister(this.redisCommands, sha -> this.register0(namespace, (String)sha, serviceInstance));
    }

    private void ensureNamespacedInstance(String namespace, ServiceInstance serviceInstance) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkNotNull((Object)serviceInstance, (Object)"serviceInstance can not be null!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceInstance.getServiceId()) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceInstance.getSchema()) ? 1 : 0) != 0, (Object)"schema can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceInstance.getHost()) ? 1 : 0) != 0, (Object)"host can not be empty!");
    }

    private void ensureInstanceId(ServiceInstance serviceInstance) {
        if (Strings.isNullOrEmpty((String)serviceInstance.getInstanceId())) {
            serviceInstance.setInstanceId(InstanceIdGenerator.DEFAULT.generate(serviceInstance));
        }
    }

    private void addEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.put(NamespacedInstanceId.of(namespace, serviceInstance.getInstanceId()), serviceInstance);
    }

    private void removeEphemeralInstance(String namespace, String instanceId) {
        this.registeredEphemeralInstances.remove(NamespacedInstanceId.of(namespace, instanceId));
    }

    private void removeEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.registeredEphemeralInstances.remove(NamespacedInstanceId.of(namespace, serviceInstance.getInstanceId()));
    }

    @Override
    public Map<NamespacedInstanceId, ServiceInstance> getRegisteredEphemeralInstances() {
        return this.registeredEphemeralInstances;
    }

    @Override
    public Mono<Boolean> setMetadata(String namespace, String serviceId, String instanceId, String key, String value) {
        String[] values = new String[]{instanceId, key, value};
        return this.setMetadata0(namespace, instanceId, values);
    }

    @Override
    public Mono<Boolean> setMetadata(String namespace, String serviceId, String instanceId, Map<String, String> metadata) {
        String[] values = ServiceInstanceCodec.encodeMetadata(new String[]{instanceId}, metadata);
        return this.setMetadata0(namespace, instanceId, values);
    }

    private Mono<Boolean> setMetadata0(String namespace, String instanceId, String[] args) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId can not be empty!");
        if (log.isInfoEnabled()) {
            log.info("setMetadata - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        String[] keys = new String[]{namespace};
        return DiscoveryRedisScripts.doRegistrySetMetadata(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, (Object[])keys, (Object[])args).cast(Boolean.class).next());
    }

    @Override
    public Mono<Boolean> renew(String namespace, ServiceInstance serviceInstance) {
        this.ensureNamespacedInstance(namespace, serviceInstance);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceInstance.getInstanceId()) ? 1 : 0) != 0, (Object)"instanceId can not be empty!");
        if (log.isDebugEnabled()) {
            log.debug("renew - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        if (!serviceInstance.isEphemeral()) {
            if (log.isWarnEnabled()) {
                log.warn("renew - instanceId:[{}] @ namespace:[{}] is not ephemeral, can not renew.", (Object)serviceInstance.getInstanceId(), (Object)namespace);
            }
            return Mono.just((Object)Boolean.FALSE);
        }
        String[] keys = new String[]{namespace};
        String[] values = new String[]{serviceInstance.getInstanceId(), String.valueOf(this.registryProperties.getInstanceTtl())};
        return DiscoveryRedisScripts.doRegistryRenew(this.redisCommands, sha -> this.redisCommands.evalsha(sha, ScriptOutputType.INTEGER, (Object[])keys, (Object[])values).cast(Long.class).next()).flatMap(status -> {
            if (status <= 0L) {
                if (log.isWarnEnabled()) {
                    log.warn("renew - instanceId:[{}] @ namespace:[{}] status is [{}],register again.", new Object[]{serviceInstance.getInstanceId(), namespace, status});
                }
                return this.register(namespace, serviceInstance);
            }
            return Mono.just((Object)Boolean.TRUE);
        });
    }

    @Override
    public Mono<Boolean> deregister(String namespace, String serviceId, String instanceId) {
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)instanceId, (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, instanceId);
        return this.deregister0(namespace, serviceId, instanceId);
    }

    private Mono<Boolean> deregister0(String namespace, String serviceId, String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)namespace) ? 1 : 0) != 0, (Object)"namespace can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceId) ? 1 : 0) != 0, (Object)"serviceId can not be empty!");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"instanceId can not be empty!");
        return DiscoveryRedisScripts.doRegistryDeregister(this.redisCommands, sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{serviceId, instanceId};
            return this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values).cast(Boolean.class).next();
        });
    }

    @Override
    public Mono<Boolean> deregister(String namespace, ServiceInstance serviceInstance) {
        this.ensureInstanceId(serviceInstance);
        if (log.isInfoEnabled()) {
            log.info("deregister - instanceId:[{}] @ namespace:[{}].", (Object)serviceInstance.getInstanceId(), (Object)namespace);
        }
        this.removeEphemeralInstance(namespace, serviceInstance);
        return this.deregister0(namespace, serviceInstance.getServiceId(), serviceInstance.getInstanceId());
    }
}

