/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Instance {
    private String instanceId;
    private String serviceId;
    private String schema;
    private String host;
    private int port;
    private static final Set<String> secureSchemas = new HashSet<String>();

    public static URI getUri(Instance instance) {
        String uri = Strings.lenientFormat((String)"%s://%s:%s", (Object[])new Object[]{instance.getSchema(), instance.getHost(), instance.getPort()});
        return URI.create(uri);
    }

    public URI parseUri() {
        return Instance.getUri(this);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setSchema(String schema) {
        this.schema = schema.toLowerCase(Locale.ROOT);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return secureSchemas.contains(this.schema);
    }

    public String toString() {
        return this.instanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Instance)) {
            return false;
        }
        Instance instance = (Instance)o;
        return this.getPort() == instance.getPort() && Objects.equal((Object)this.getServiceId(), (Object)instance.getServiceId()) && Objects.equal((Object)this.getSchema(), (Object)instance.getSchema()) && Objects.equal((Object)this.getHost(), (Object)instance.getHost());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getServiceId(), this.getSchema(), this.getHost(), this.getPort()});
    }

    static {
        secureSchemas.add("https");
        secureSchemas.add("wss");
    }
}

