/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.Map;
import me.ahoo.cosky.core.NamespacedContext;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.ServiceInstance;
import reactor.core.publisher.Mono;

public interface ServiceRegistry {
    public Mono<Boolean> setService(String var1, String var2);

    public Mono<Boolean> removeService(String var1, String var2);

    default public Mono<Boolean> register(ServiceInstance serviceInstance) {
        return this.register(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceInstance);
    }

    public Mono<Boolean> register(String var1, ServiceInstance var2);

    default public Mono<Boolean> renew(ServiceInstance serviceInstance) {
        return this.renew(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceInstance);
    }

    public Mono<Boolean> renew(String var1, ServiceInstance var2);

    default public Mono<Boolean> deregister(ServiceInstance serviceInstance) {
        return this.deregister(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceInstance);
    }

    public Mono<Boolean> deregister(String var1, ServiceInstance var2);

    default public Mono<Boolean> deregister(String serviceId, String instanceId) {
        return this.deregister(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceId, instanceId);
    }

    public Mono<Boolean> deregister(String var1, String var2, String var3);

    public Map<NamespacedInstanceId, ServiceInstance> getRegisteredEphemeralInstances();

    default public Mono<Boolean> setMetadata(String serviceId, String instanceId, String key, String value) {
        return this.setMetadata(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceId, instanceId, key, value);
    }

    public Mono<Boolean> setMetadata(String var1, String var2, String var3, String var4, String var5);

    default public Mono<Boolean> setMetadata(String serviceId, String instanceId, Map<String, String> metadata) {
        return this.setMetadata(NamespacedContext.GLOBAL.getRequiredNamespace(), serviceId, instanceId, metadata);
    }

    public Mono<Boolean> setMetadata(String var1, String var2, String var3, Map<String, String> var4);
}

