/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceChangedEvent;
import me.ahoo.cosky.discovery.ServiceChangedListener;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import me.ahoo.cosky.discovery.redis.ConsistencyRedisServiceDiscovery;
import reactor.core.publisher.Mono;

public abstract class AbstractLoadBalancer<Chooser extends LoadBalancer.Chooser>
implements LoadBalancer {
    private final ConcurrentHashMap<NamespacedServiceId, Mono<Chooser>> serviceMapChooser;
    private final ConsistencyRedisServiceDiscovery serviceDiscovery;
    private final Listener listener;

    public AbstractLoadBalancer(ConsistencyRedisServiceDiscovery serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
        this.serviceMapChooser = new ConcurrentHashMap();
        this.listener = new Listener();
    }

    private Mono<Chooser> ensureChooser(NamespacedServiceId namespacedServiceId) {
        return this.serviceMapChooser.computeIfAbsent(namespacedServiceId, key -> {
            this.serviceDiscovery.addListener((NamespacedServiceId)key, this.listener);
            return this.serviceDiscovery.getInstances(key.getNamespace(), key.getServiceId()).map(this::createChooser).cache();
        });
    }

    @Override
    public Mono<ServiceInstance> choose(String namespace, String serviceId) {
        return this.ensureChooser(NamespacedServiceId.of(namespace, serviceId)).mapNotNull(LoadBalancer.Chooser::choose);
    }

    protected abstract Chooser createChooser(List<ServiceInstance> var1);

    private class Listener
    implements ServiceChangedListener {
        private Listener() {
        }

        @Override
        public void onChange(ServiceChangedEvent serviceChangedEvent) {
            NamespacedServiceId namespacedServiceId = serviceChangedEvent.getNamespacedServiceId();
            AbstractLoadBalancer.this.serviceMapChooser.remove(namespacedServiceId);
            AbstractLoadBalancer.this.ensureChooser(namespacedServiceId);
        }
    }
}

