/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.core.redis.RedisEventListenerContainer;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.ServiceEventListenerContainer;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReactiveSubscription;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.ReactiveRedisMessageListenerContainer;
import reactor.core.publisher.Flux;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\rB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0014J\"\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t0\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0014\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceEventListenerContainer;", "Lme/ahoo/cosky/discovery/ServiceEventListenerContainer;", "Lme/ahoo/cosky/core/redis/RedisEventListenerContainer;", "", "delegate", "Lorg/springframework/data/redis/listener/ReactiveRedisMessageListenerContainer;", "(Lorg/springframework/data/redis/listener/ReactiveRedisMessageListenerContainer;)V", "asEvent", "message", "Lorg/springframework/data/redis/connection/ReactiveSubscription$Message;", "receive", "Lreactor/core/publisher/Flux;", "topic", "Companion", "cosky-discovery"})
public final class RedisServiceEventListenerContainer
extends RedisEventListenerContainer<String, String>
implements ServiceEventListenerContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(RedisServiceEventListenerContainer.class);

    public RedisServiceEventListenerContainer(@NotNull ReactiveRedisMessageListenerContainer delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate);
    }

    @NotNull
    protected Flux<ReactiveSubscription.Message<String, String>> receive(@NotNull String topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Flux flux = Flux.defer(() -> RedisServiceEventListenerContainer.receive$lambda$0(topic, this));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"defer {\n            if (\u2026serviceIdxKey))\n        }");
        return flux;
    }

    @NotNull
    protected String asEvent(@NotNull ReactiveSubscription.Message<String, String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Object object = message.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"message.channel");
        return DiscoveryKeyGenerator.getNamespaceOfKey((String)object);
    }

    private static final Publisher receive$lambda$0(String $topic, RedisServiceEventListenerContainer this$0) {
        Intrinsics.checkNotNullParameter((Object)$topic, (String)"$topic");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (log.isDebugEnabled()) {
            log.debug("Receive - topic:{}", (Object)$topic);
        }
        String serviceIdxKey = DiscoveryKeyGenerator.getServiceIdxKey($topic);
        ChannelTopic[] channelTopicArray = new ChannelTopic[]{ChannelTopic.of((String)serviceIdxKey)};
        return (Publisher)this$0.getDelegate().receive(channelTopicArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceEventListenerContainer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

