/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\f\rB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/AbstractLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$BinaryChooser;", "serviceDiscovery", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "createChooser", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "BinaryChooser", "Companion", "cosky-discovery"})
public final class BinaryWeightRandomLoadBalancer
extends AbstractLoadBalancer<BinaryChooser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(BinaryWeightRandomLoadBalancer.class);

    public BinaryWeightRandomLoadBalancer(@NotNull ServiceDiscovery serviceDiscovery, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)serviceDiscovery, (String)"serviceDiscovery");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        super(serviceDiscovery, instanceEventListenerContainer);
    }

    @Override
    @NotNull
    protected BinaryChooser createChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
        Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
        return new BinaryChooser(serviceInstances);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$BinaryChooser;", "Lme/ahoo/cosky/discovery/loadbalancer/LoadBalancer$Chooser;", "instanceList", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "(Ljava/util/List;)V", "maxLineIndex", "", "randomBound", "totalWeight", "weightLine", "", "binarySearchLowIndex", "randomValue", "choose", "cosky-discovery"})
    public static final class BinaryChooser
    implements LoadBalancer.Chooser {
        @NotNull
        private final List<ServiceInstance> instanceList;
        private final int totalWeight;
        private final int randomBound;
        @NotNull
        private final int[] weightLine;
        private final int maxLineIndex;

        public BinaryChooser(@NotNull List<? extends ServiceInstance> instanceList) {
            Intrinsics.checkNotNullParameter(instanceList, (String)"instanceList");
            this.instanceList = instanceList;
            this.maxLineIndex = this.instanceList.size() - 1;
            this.weightLine = new int[this.instanceList.size()];
            int accWeight = 0;
            int n = this.instanceList.size();
            for (int i = 0; i < n; ++i) {
                int instanceWeight = this.instanceList.get(i).getWeight();
                if (instanceWeight == 0) continue;
                this.weightLine[i] = accWeight += instanceWeight;
            }
            this.totalWeight = accWeight;
            this.randomBound = this.totalWeight + 1;
        }

        @Override
        @Nullable
        public ServiceInstance choose() {
            if (this.weightLine.length == 0) {
                if (log.isWarnEnabled()) {
                    log.warn("choose - The size of connector instances is [{}]!", (Object)this.weightLine.length);
                }
                return null;
            }
            if (this.totalWeight == 0) {
                log.warn("choose - The size of connector instances is [{}],but total weight is 0!", (Object)this.weightLine.length);
                return null;
            }
            if (this.weightLine.length == 1) {
                return this.instanceList.get(0);
            }
            int randomValue = ThreadLocalRandom.current().nextInt(1, this.randomBound);
            if (randomValue == 1) {
                return this.instanceList.get(0);
            }
            if (randomValue == this.totalWeight) {
                return this.instanceList.get(this.maxLineIndex);
            }
            int instanceIdx = this.binarySearchLowIndex(randomValue);
            return this.instanceList.get(instanceIdx);
        }

        private final int binarySearchLowIndex(int randomValue) {
            int idx = Arrays.binarySearch(this.weightLine, randomValue);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return idx;
        }
    }
}

