/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.ServiceInstanceContext;
import me.ahoo.cosky.discovery.ServiceTopology;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import me.ahoo.cosky.discovery.redis.RedisServiceTopology;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J(\u0010\u000b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\f0\u00062\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceTopology;", "Lme/ahoo/cosky/discovery/ServiceTopology;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "(Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;)V", "addTopology", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "producerNamespace", "", "producerServiceId", "getTopology", "", "", "namespace", "cosky-discovery"})
public final class RedisServiceTopology
implements ServiceTopology {
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;

    public RedisServiceTopology(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        this.redisTemplate = redisTemplate;
    }

    @Override
    @NotNull
    public Mono<Void> addTopology(@NotNull String producerNamespace, @NotNull String producerServiceId) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)producerNamespace, (String)"producerNamespace");
        Intrinsics.checkNotNullParameter((Object)producerServiceId, (String)"producerServiceId");
        String consumerNamespace = ServiceInstanceContext.INSTANCE.getNamespace();
        String consumerName = ServiceTopology.Companion.getConsumerName();
        String producerName = ServiceTopology.Companion.getProducerName(producerNamespace, producerServiceId);
        if (Intrinsics.areEqual((Object)consumerName, (Object)producerName)) {
            Mono mono2 = Mono.empty();
            mono = mono2;
            Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"{\n            Mono.empty()\n        }");
        } else {
            Object[] objectArray = new String[]{consumerName, producerName};
            Mono mono3 = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_TOPOLOGY_ADD(), CollectionsKt.listOf((Object)consumerNamespace), CollectionsKt.listOf((Object[])objectArray)).then();
            mono = mono3;
            Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"{\n            redisTempl\u2026       ).then()\n        }");
        }
        return mono;
    }

    @Override
    @NotNull
    public Mono<Map<String, Set<String>>> getTopology(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_SERVICE_TOPOLOGY_GET(), CollectionsKt.listOf((Object)namespace)).map(arg_0 -> RedisServiceTopology.getTopology$lambda$1(getTopology.2.INSTANCE, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"redisTemplate.execute(\n \u2026    }\n            .next()");
        return mono;
    }

    private static final Map getTopology$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }
}

