/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.InstanceChangedEvent;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceStat;
import me.ahoo.cosky.discovery.ServiceStatistic;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import me.ahoo.cosky.discovery.redis.RedisServiceStatistic;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\f2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceStatistic;", "Lme/ahoo/cosky/discovery/ServiceStatistic;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "(Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "listenedNamespaces", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lreactor/core/Disposable;", "countService", "Lreactor/core/publisher/Mono;", "", "namespace", "getInstanceCount", "getServiceStats", "Lreactor/core/publisher/Flux;", "Lme/ahoo/cosky/discovery/ServiceStat;", "instanceChanged", "", "event", "Lme/ahoo/cosky/discovery/InstanceChangedEvent;", "startListeningServiceInstancesOfNamespace", "statService", "Ljava/lang/Void;", "serviceId", "statServiceInternal", "Companion", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nRedisServiceStatistic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisServiceStatistic.kt\nme/ahoo/cosky/discovery/redis/RedisServiceStatistic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class RedisServiceStatistic
implements ServiceStatistic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;
    @NotNull
    private final InstanceEventListenerContainer instanceEventListenerContainer;
    @NotNull
    private final ConcurrentHashMap<String, Disposable> listenedNamespaces;
    private static final Logger log = LoggerFactory.getLogger(RedisServiceStatistic.class);

    public RedisServiceStatistic(@NotNull ReactiveStringRedisTemplate redisTemplate, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        this.redisTemplate = redisTemplate;
        this.instanceEventListenerContainer = instanceEventListenerContainer;
        this.listenedNamespaces = new ConcurrentHashMap();
    }

    private final void startListeningServiceInstancesOfNamespace(String namespace) {
        this.listenedNamespaces.computeIfAbsent(namespace, arg_0 -> RedisServiceStatistic.startListeningServiceInstancesOfNamespace$lambda$0((Function1)new Function1<String, Disposable>(this, namespace){
            final /* synthetic */ RedisServiceStatistic this$0;
            final /* synthetic */ String $namespace;
            {
                this.this$0 = $receiver;
                this.$namespace = $namespace;
                super(1);
            }

            @NotNull
            public final Disposable invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return RedisServiceStatistic.access$getInstanceEventListenerContainer$p(this.this$0).listen(new NamespacedServiceId(this.$namespace, "")).doOnNext(arg_0 -> startListeningServiceInstancesOfNamespace.1.invoke$lambda$0((Function1)new Function1<InstanceChangedEvent, Unit>(this.this$0){
                    final /* synthetic */ RedisServiceStatistic this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(InstanceChangedEvent it) {
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        RedisServiceStatistic.access$instanceChanged(this.this$0, it);
                    }
                }, arg_0)).subscribe();
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void instanceChanged(InstanceChangedEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("instanceChanged - event:[{}]", (Object)event);
        }
        if (InstanceChangedEvent.Event.RENEW == event.getEvent()) {
            return;
        }
        this.statServiceInternal(event.getNamespacedServiceId().getNamespace(), event.getNamespacedServiceId().getServiceId()).subscribe();
    }

    @Override
    @NotNull
    public Mono<Void> statService(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.startListeningServiceInstancesOfNamespace(namespace);
        return this.statServiceInternal(namespace, null);
    }

    @Override
    @NotNull
    public Mono<Void> statService(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        return this.statServiceInternal(namespace, serviceId);
    }

    private final Mono<Void> statServiceInternal(String namespace, String serviceId) {
        CharSequence charSequence;
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("statService  @ namespace:[{}].", (Object)namespace);
        }
        List values = !((charSequence = (CharSequence)serviceId) == null || charSequence.length() == 0) ? CollectionsKt.listOf((Object)serviceId) : CollectionsKt.emptyList();
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_SERVICE_STAT(), CollectionsKt.listOf((Object)namespace), values).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"redisTemplate.execute(\n \u2026 values,\n        ).then()");
        return mono;
    }

    @NotNull
    public final Mono<Long> countService(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        Mono mono = this.redisTemplate.opsForHash().size((Object)serviceIdxStatKey);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"redisTemplate\n          \u2026 .size(serviceIdxStatKey)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<ServiceStat> getServiceStats(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        Flux flux = this.redisTemplate.opsForHash().entries((Object)serviceIdxStatKey).map(arg_0 -> RedisServiceStatistic.getServiceStats$lambda$4(getServiceStats.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"redisTemplate\n          \u2026ue.toInt())\n            }");
        return flux;
    }

    @Override
    @NotNull
    public Mono<Long> getInstanceCount(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_INSTANCE_COUNT_STAT(), CollectionsKt.listOf((Object)namespace)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"redisTemplate.execute(\n \u2026espace),\n        ).next()");
        return mono;
    }

    private static final Disposable startListeningServiceInstancesOfNamespace$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Disposable)$tmp0.invoke(p0);
    }

    private static final ServiceStat getServiceStats$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ServiceStat)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ InstanceEventListenerContainer access$getInstanceEventListenerContainer$p(RedisServiceStatistic $this) {
        return $this.instanceEventListenerContainer;
    }

    public static final /* synthetic */ void access$instanceChanged(RedisServiceStatistic $this, InstanceChangedEvent event) {
        $this.instanceChanged(event);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceStatistic$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

