/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.NoOpConsumeRenewInstance;
import me.ahoo.cosky.discovery.RenewInstanceService;
import me.ahoo.cosky.discovery.RenewProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService;", "", "renewProperties", "Lme/ahoo/cosky/discovery/RenewProperties;", "serviceRegistry", "Lme/ahoo/cosky/discovery/ServiceRegistry;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "hookOnRenew", "Ljava/util/function/Consumer;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "(Lme/ahoo/cosky/discovery/RenewProperties;Lme/ahoo/cosky/discovery/ServiceRegistry;Lreactor/core/scheduler/Scheduler;Ljava/util/function/Consumer;)V", "renewCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleDisposable", "Lreactor/core/Disposable;", "renew", "", "start", "stop", "Companion", "cosky-discovery"})
public final class RenewInstanceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenewProperties renewProperties;
    @NotNull
    private final ServiceRegistry serviceRegistry;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Consumer<ServiceInstance> hookOnRenew;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicInteger renewCounter;
    @Nullable
    private Disposable scheduleDisposable;
    private static final Logger log = LoggerFactory.getLogger(RenewInstanceService.class);

    public RenewInstanceService(@NotNull RenewProperties renewProperties, @NotNull ServiceRegistry serviceRegistry, @NotNull Scheduler scheduler, @NotNull Consumer<ServiceInstance> hookOnRenew) {
        Intrinsics.checkNotNullParameter((Object)renewProperties, (String)"renewProperties");
        Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(hookOnRenew, (String)"hookOnRenew");
        this.renewProperties = renewProperties;
        this.serviceRegistry = serviceRegistry;
        this.scheduler = scheduler;
        this.hookOnRenew = hookOnRenew;
        this.running = new AtomicBoolean(false);
        this.renewCounter = new AtomicInteger();
    }

    public /* synthetic */ RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry, Scheduler scheduler, Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Scheduler scheduler2 = Schedulers.newSingle((String)"CoSky-Renew", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)scheduler2, (String)"newSingle(...)");
            scheduler = scheduler2;
        }
        if ((n & 8) != 0) {
            consumer = NoOpConsumeRenewInstance.INSTANCE;
        }
        this(renewProperties, serviceRegistry, scheduler, consumer);
    }

    public final void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Start.");
        }
        this.scheduleDisposable = this.scheduler.schedulePeriodically(() -> RenewInstanceService.start$lambda$0(this), this.renewProperties.getInitialDelay().getSeconds(), this.renewProperties.getPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public final void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Stop.");
        }
        Disposable disposable = this.scheduleDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.scheduler.dispose();
    }

    private final void renew() {
        int times = this.renewCounter.incrementAndGet();
        Map<NamespacedInstanceId, ServiceInstance> instances = this.serviceRegistry.getRegisteredEphemeralInstances();
        if (log.isDebugEnabled()) {
            log.debug("Renew - instances size:{} start - times@[{}] .", (Object)instances.size(), (Object)times);
        }
        if (instances.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Renew - instances size:{} end - times@[{}] .", (Object)instances.size(), (Object)times);
            }
            return;
        }
        Flux.fromIterable((Iterable)instances.entrySet()).flatMap(arg_0 -> RenewInstanceService.renew$lambda$1((Function1)new Function1<Map.Entry<? extends NamespacedInstanceId, ? extends ServiceInstance>, Publisher<? extends Boolean>>(this){
            final /* synthetic */ RenewInstanceService this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends Boolean> invoke(Map.Entry<NamespacedInstanceId, ? extends ServiceInstance> entry) {
                Intrinsics.checkNotNull(entry);
                NamespacedInstanceId key = entry.getKey();
                ServiceInstance value = entry.getValue();
                return (Publisher)RenewInstanceService.access$getServiceRegistry$p(this.this$0).renew(key.getNamespace(), value).doOnSuccess(arg_0 -> renew.1.invoke$lambda$0((Function1)new Function1<Boolean, Unit>(this.this$0, value){
                    final /* synthetic */ RenewInstanceService this$0;
                    final /* synthetic */ ServiceInstance $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(1);
                    }

                    public final void invoke(Boolean it) {
                        RenewInstanceService.access$getHookOnRenew$p(this.this$0).accept(this.$value);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)).doOnError(arg_0 -> RenewInstanceService.renew$lambda$2(renew.2.INSTANCE, arg_0)).doOnComplete(() -> RenewInstanceService.renew$lambda$3(instances, times)).subscribe();
    }

    private static final void start$lambda$0(RenewInstanceService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.renew();
    }

    private static final Publisher renew$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void renew$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void renew$lambda$3(Map $instances, int $times) {
        Intrinsics.checkNotNullParameter((Object)$instances, (String)"$instances");
        if (log.isDebugEnabled()) {
            log.debug("Renew - instances size:{} end - times@[{}].", (Object)$instances.size(), (Object)$times);
        }
    }

    public static final /* synthetic */ ServiceRegistry access$getServiceRegistry$p(RenewInstanceService $this) {
        return $this.serviceRegistry;
    }

    public static final /* synthetic */ Consumer access$getHookOnRenew$p(RenewInstanceService $this) {
        return $this.hookOnRenew;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

