/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.NoOpConsumeRenewInstance;
import me.ahoo.cosky.discovery.RenewProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService;", "", "renewProperties", "Lme/ahoo/cosky/discovery/RenewProperties;", "serviceRegistry", "Lme/ahoo/cosky/discovery/ServiceRegistry;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "hookOnRenew", "Ljava/util/function/Consumer;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Lme/ahoo/cosky/discovery/RenewProperties;Lme/ahoo/cosky/discovery/ServiceRegistry;Lreactor/core/scheduler/Scheduler;Ljava/util/function/Consumer;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "renewCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "scheduleDisposable", "Lreactor/core/Disposable;", "start", "", "stop", "renew", "Companion", "cosky-discovery"})
public final class RenewInstanceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenewProperties renewProperties;
    @NotNull
    private final ServiceRegistry serviceRegistry;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Consumer<ServiceInstance> hookOnRenew;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicInteger renewCounter;
    @Nullable
    private Disposable scheduleDisposable;
    private static final Logger log = LoggerFactory.getLogger(RenewInstanceService.class);

    public RenewInstanceService(@NotNull RenewProperties renewProperties, @NotNull ServiceRegistry serviceRegistry, @NotNull Scheduler scheduler, @NotNull Consumer<ServiceInstance> hookOnRenew) {
        Intrinsics.checkNotNullParameter((Object)renewProperties, (String)"renewProperties");
        Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(hookOnRenew, (String)"hookOnRenew");
        this.renewProperties = renewProperties;
        this.serviceRegistry = serviceRegistry;
        this.scheduler = scheduler;
        this.hookOnRenew = hookOnRenew;
        this.running = new AtomicBoolean(false);
        this.renewCounter = new AtomicInteger();
    }

    public /* synthetic */ RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry, Scheduler scheduler, Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            scheduler = Schedulers.newSingle((String)"CoSky-Renew", (boolean)true);
        }
        if ((n & 8) != 0) {
            consumer = NoOpConsumeRenewInstance.INSTANCE;
        }
        this(renewProperties, serviceRegistry, scheduler, consumer);
    }

    public final void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Start.");
        }
        this.scheduleDisposable = this.scheduler.schedulePeriodically(() -> RenewInstanceService.start$lambda$0(this), this.renewProperties.getInitialDelay().getSeconds(), this.renewProperties.getPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public final void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Stop.");
        }
        Disposable disposable = this.scheduleDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.scheduler.dispose();
    }

    private final void renew() {
        int times = this.renewCounter.incrementAndGet();
        Map<NamespacedInstanceId, ServiceInstance> instances = this.serviceRegistry.getRegisteredEphemeralInstances();
        if (log.isDebugEnabled()) {
            log.debug("Renew - instances size:{} start - times@[{}] .", (Object)instances.size(), (Object)times);
        }
        if (instances.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Renew - instances size:{} end - times@[{}] .", (Object)instances.size(), (Object)times);
            }
            return;
        }
        Flux.fromIterable((Iterable)instances.entrySet()).flatMap(arg_0 -> RenewInstanceService.renew$lambda$4(arg_0 -> RenewInstanceService.renew$lambda$3(this, arg_0), arg_0)).doOnError(arg_0 -> RenewInstanceService.renew$lambda$6(RenewInstanceService::renew$lambda$5, arg_0)).doOnComplete(() -> RenewInstanceService.renew$lambda$7(instances, times)).subscribe();
    }

    private static final void start$lambda$0(RenewInstanceService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.renew();
    }

    private static final Unit renew$lambda$3$lambda$1(RenewInstanceService this$0, ServiceInstance $value, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        this$0.hookOnRenew.accept($value);
        return Unit.INSTANCE;
    }

    private static final void renew$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher renew$lambda$3(RenewInstanceService this$0, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)entry);
        NamespacedInstanceId key = (NamespacedInstanceId)entry.getKey();
        ServiceInstance value = (ServiceInstance)entry.getValue();
        return (Publisher)this$0.serviceRegistry.renew(key.getNamespace(), value).doOnSuccess(arg_0 -> RenewInstanceService.renew$lambda$3$lambda$2(arg_0 -> RenewInstanceService.renew$lambda$3$lambda$1(this$0, value, arg_0), arg_0));
    }

    private static final Publisher renew$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Unit renew$lambda$5(Throwable it) {
        if (log.isWarnEnabled()) {
            log.warn("Renew - failed.", it);
        }
        return Unit.INSTANCE;
    }

    private static final void renew$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void renew$lambda$7(Map $instances, int $times) {
        Intrinsics.checkNotNullParameter((Object)$instances, (String)"$instances");
        if (log.isDebugEnabled()) {
            log.debug("Renew - instances size:{} end - times@[{}].", (Object)$instances.size(), (Object)$times);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

