/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/TreeWeightRandomLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/AbstractLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/TreeWeightRandomLoadBalancer$TreeChooser;", "serviceDiscovery", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "<init>", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "createChooser", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "Companion", "TreeChooser", "cosky-discovery"})
public final class TreeWeightRandomLoadBalancer
extends AbstractLoadBalancer<TreeChooser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(TreeWeightRandomLoadBalancer.class);

    public TreeWeightRandomLoadBalancer(@NotNull ServiceDiscovery serviceDiscovery, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)serviceDiscovery, (String)"serviceDiscovery");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        super(serviceDiscovery, instanceEventListenerContainer);
    }

    @Override
    @NotNull
    protected TreeChooser createChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
        Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
        return new TreeChooser(serviceInstances);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/TreeWeightRandomLoadBalancer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/TreeWeightRandomLoadBalancer$TreeChooser;", "Lme/ahoo/cosky/discovery/loadbalancer/LoadBalancer$Chooser;", "instanceList", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Ljava/util/List;)V", "instanceTree", "Ljava/util/TreeMap;", "", "totalWeight", "choose", "cosky-discovery"})
    public static final class TreeChooser
    implements LoadBalancer.Chooser {
        @NotNull
        private final TreeMap<Integer, ServiceInstance> instanceTree;
        private final int totalWeight;

        public TreeChooser(@NotNull List<? extends ServiceInstance> instanceList) {
            Intrinsics.checkNotNullParameter(instanceList, (String)"instanceList");
            this.instanceTree = new TreeMap();
            int accWeight = 0;
            for (ServiceInstance serviceInstance : instanceList) {
                if (serviceInstance.getWeight() == 0) continue;
                Integer n = accWeight += serviceInstance.getWeight();
                ((Map)this.instanceTree).put(n, serviceInstance);
            }
            this.totalWeight = accWeight;
        }

        @Override
        @Nullable
        public ServiceInstance choose() {
            if (this.instanceTree.size() == 0) {
                if (log.isWarnEnabled()) {
                    log.warn("choose - The size of connector instances is [{}]!", (Object)this.instanceTree.size());
                }
                return null;
            }
            if (this.totalWeight == 0) {
                log.warn("choose - The size of connector instances is [{}],but total weight is 0!", (Object)this.instanceTree.size());
                return null;
            }
            if (this.instanceTree.size() == 1) {
                return this.instanceTree.firstEntry().getValue();
            }
            int randomVal = ThreadLocalRandom.current().nextInt(0, this.totalWeight);
            NavigableMap<Integer, ServiceInstance> tailMap = this.instanceTree.tailMap(randomVal, false);
            return tailMap.firstEntry().getValue();
        }
    }
}

