/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceCodec;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceDiscovery;", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "<init>", "(Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;)V", "getInstances", "Lreactor/core/publisher/Flux;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "namespace", "", "serviceId", "getInstance", "Lreactor/core/publisher/Mono;", "instanceId", "getInstanceTtl", "", "getServices", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nRedisServiceDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisServiceDiscovery.kt\nme/ahoo/cosky/discovery/redis/RedisServiceDiscovery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1#2:98\n1557#3:99\n1628#3,3:100\n*S KotlinDebug\n*F\n+ 1 RedisServiceDiscovery.kt\nme/ahoo/cosky/discovery/redis/RedisServiceDiscovery\n*L\n50#1:99\n50#1:100,3\n*E\n"})
public final class RedisServiceDiscovery
implements ServiceDiscovery {
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;

    public RedisServiceDiscovery(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        this.redisTemplate = redisTemplate;
    }

    @Override
    @NotNull
    public Flux<ServiceInstance> getInstances(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceDiscovery$getInstances$32 = false;
            String $i$a$-require-RedisServiceDiscovery$getInstances$32 = "namespace is blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceDiscovery$getInstances$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean bl = false;
            String string = "serviceId is blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Flux flux = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_GET_INSTANCES(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object)serviceId)).flatMapIterable(arg_0 -> RedisServiceDiscovery.getInstances$lambda$4(RedisServiceDiscovery::getInstances$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapIterable(...)");
        return flux;
    }

    @Override
    @NotNull
    public Mono<ServiceInstance> getInstance(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceDiscovery$getInstance$42 = false;
            String $i$a$-require-RedisServiceDiscovery$getInstance$42 = "namespace is blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceDiscovery$getInstance$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean $i$a$-require-RedisServiceDiscovery$getInstance$52 = false;
            String $i$a$-require-RedisServiceDiscovery$getInstance$52 = "serviceId is blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceDiscovery$getInstance$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)instanceId))) {
            boolean bl = false;
            String string = "instanceId is blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{serviceId, instanceId};
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_GET_INSTANCE(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object[])objectArray)).map(arg_0 -> RedisServiceDiscovery.getInstance$lambda$9(RedisServiceDiscovery::getInstance$lambda$8, arg_0)).mapNotNull(arg_0 -> RedisServiceDiscovery.getInstance$lambda$11(RedisServiceDiscovery::getInstance$lambda$10, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Long> getInstanceTtl(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceDiscovery$getInstanceTtl$42 = false;
            String $i$a$-require-RedisServiceDiscovery$getInstanceTtl$42 = "namespace is blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceDiscovery$getInstanceTtl$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean $i$a$-require-RedisServiceDiscovery$getInstanceTtl$52 = false;
            String $i$a$-require-RedisServiceDiscovery$getInstanceTtl$52 = "serviceId is blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceDiscovery$getInstanceTtl$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)instanceId))) {
            boolean bl = false;
            String string = "instanceId is blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{serviceId, instanceId};
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_GET_INSTANCE_TTL(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object[])objectArray)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<String> getServices(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace is blank!";
            throw new IllegalArgumentException(string.toString());
        }
        String serviceIdxKey = DiscoveryKeyGenerator.getServiceIdxKey(namespace);
        Flux flux = this.redisTemplate.opsForSet().members((Object)serviceIdxKey);
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"members(...)");
        return flux;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getInstances$lambda$3(List instanceGroups) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNull((Object)instanceGroups, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.collections.List<kotlin.String>>");
        List groups = instanceGroups;
        if (instanceGroups.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = groups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ServiceInstanceCodec.INSTANCE.decode((List<String>)it));
        }
        return (List)destination$iv$iv;
    }

    private static final Iterable getInstances$lambda$4(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final List getInstance$lambda$8(List it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
        return it;
    }

    private static final List getInstance$lambda$9(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final ServiceInstance getInstance$lambda$10(List it) {
        if (it.isEmpty()) {
            return null;
        }
        Intrinsics.checkNotNull((Object)it);
        return ServiceInstanceCodec.INSTANCE.decode(it);
    }

    private static final ServiceInstance getInstance$lambda$11(Function1 $tmp0, Object p0) {
        return (ServiceInstance)$tmp0.invoke(p0);
    }
}

