/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/AbstractLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer$ArrayChooser;", "serviceDiscovery", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "<init>", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "createChooser", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "Companion", "ArrayChooser", "cosky-discovery"})
public final class ArrayWeightRandomLoadBalancer
extends AbstractLoadBalancer<ArrayChooser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(ArrayWeightRandomLoadBalancer::log$lambda$0);

    public ArrayWeightRandomLoadBalancer(@NotNull ServiceDiscovery serviceDiscovery, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)serviceDiscovery, (String)"serviceDiscovery");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        super(serviceDiscovery, instanceEventListenerContainer);
    }

    @Override
    @NotNull
    protected ArrayChooser createChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
        Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
        return new ArrayChooser(serviceInstances);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer$ArrayChooser;", "Lme/ahoo/cosky/discovery/loadbalancer/LoadBalancer$Chooser;", "instanceList", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Ljava/util/List;)V", "instanceLine", "", "[Lme/ahoo/cosky/discovery/ServiceInstance;", "totalWeight", "", "toLine", "(Ljava/util/List;)[Lme/ahoo/cosky/discovery/ServiceInstance;", "choose", "cosky-discovery"})
    @SourceDebugExtension(value={"SMAP\nArrayWeightRandomLoadBalancer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayWeightRandomLoadBalancer.kt\nme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer$ArrayChooser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1563#2:91\n1634#2,3:92\n2783#2,7:95\n*S KotlinDebug\n*F\n+ 1 ArrayWeightRandomLoadBalancer.kt\nme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer$ArrayChooser\n*L\n46#1:91\n46#1:92,3\n47#1:95,7\n*E\n"})
    public static final class ArrayChooser
    implements LoadBalancer.Chooser {
        @NotNull
        private final ServiceInstance[] instanceLine;
        private final int totalWeight;

        /*
         * WARNING - void declaration
         */
        public ArrayChooser(@NotNull List<? extends ServiceInstance> instanceList) {
            int n;
            Intrinsics.checkNotNullParameter(instanceList, (String)"instanceList");
            ArrayChooser arrayChooser = this;
            if (instanceList.isEmpty()) {
                n = 0;
            } else {
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Iterable iterable = instanceList;
                ArrayChooser arrayChooser2 = arrayChooser;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                int $i$f$mapTo = 0;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    ServiceInstance serviceInstance = (ServiceInstance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(p0.getWeight());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    $i$f$mapTo = ((Number)iterator$iv.next()).intValue();
                    int a = ((Number)accumulator$iv).intValue();
                    boolean bl = false;
                    accumulator$iv = Integer.sum(a, (int)b);
                }
                arrayChooser = arrayChooser2;
                n = ((Number)accumulator$iv).intValue();
            }
            arrayChooser.totalWeight = n;
            this.instanceLine = this.toLine(instanceList);
        }

        private final ServiceInstance[] toLine(List<? extends ServiceInstance> instanceList) {
            int n = 0;
            int n2 = this.totalWeight;
            ServiceInstance[] serviceInstanceArray = new ServiceInstance[n2];
            while (n < n2) {
                int n3 = n++;
                serviceInstanceArray[n3] = instanceList.get(0);
            }
            ServiceInstance[] line = serviceInstanceArray;
            int startX = 0;
            for (ServiceInstance serviceInstance : instanceList) {
                int weightLength = serviceInstance.getWeight();
                int idx = 0;
                while (idx < weightLength) {
                    line[startX] = serviceInstance;
                    ++idx;
                    ++startX;
                }
            }
            return line;
        }

        @Override
        @Nullable
        public ServiceInstance choose() {
            if (this.instanceLine.length == 0) {
                log.warn(ArrayChooser::choose$lambda$1);
                return null;
            }
            if (this.totalWeight == 0) {
                log.warn(() -> ArrayChooser.choose$lambda$2(this));
                return null;
            }
            if (this.instanceLine.length == 1) {
                return this.instanceLine[0];
            }
            int randomValue = ThreadLocalRandom.current().nextInt(0, this.totalWeight);
            return this.instanceLine[randomValue];
        }

        private static final Object choose$lambda$1() {
            return "choose - The size of connector instances is zero!";
        }

        private static final Object choose$lambda$2(ArrayChooser this$0) {
            return "choose - The size of connector instances is [" + this$0.instanceLine.length + "],but total weight is 0!";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/ArrayWeightRandomLoadBalancer$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

