/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/ahoo/cosky/discovery/DiscoveryKeyGenerator;", "", "<init>", "()V", "SERVICE_IDX", "", "SERVICE_STAT", "SERVICE_INSTANCE_IDX", "SERVICE_INSTANCE", "getServiceIdxKey", "namespace", "getServiceStatKey", "getNamespaceOfKey", "key", "getInstanceIdxKey", "serviceId", "getInstanceKey", "instanceId", "getInstanceKeyPatternOfNamespace", "getInstanceKeyPatternOfService", "getInstanceIdOfKey", "instanceKey", "cosky-discovery"})
public final class DiscoveryKeyGenerator {
    @NotNull
    public static final DiscoveryKeyGenerator INSTANCE = new DiscoveryKeyGenerator();
    @NotNull
    private static final String SERVICE_IDX = "svc_idx";
    @NotNull
    private static final String SERVICE_STAT = "svc_stat";
    @NotNull
    private static final String SERVICE_INSTANCE_IDX = "svc_itc_idx";
    @NotNull
    private static final String SERVICE_INSTANCE = "svc_itc";

    private DiscoveryKeyGenerator() {
    }

    @JvmStatic
    @NotNull
    public static final String getServiceIdxKey(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return namespace + ":svc_idx";
    }

    @JvmStatic
    @NotNull
    public static final String getServiceStatKey(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return namespace + ":svc_stat";
    }

    @JvmStatic
    @NotNull
    public static final String getNamespaceOfKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int firstSplitIdx = StringsKt.indexOf$default((CharSequence)key, (String)":", (int)0, (boolean)false, (int)6, null);
        String string = key.substring(0, firstSplitIdx);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getInstanceIdxKey(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        return namespace + ":svc_itc_idx:" + serviceId;
    }

    @JvmStatic
    @NotNull
    public static final String getInstanceKey(@NotNull String namespace, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        return namespace + ":svc_itc:" + instanceId;
    }

    @JvmStatic
    @NotNull
    public static final String getInstanceKeyPatternOfNamespace(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return namespace + ":svc_itc:*";
    }

    @JvmStatic
    @NotNull
    public static final String getInstanceKeyPatternOfService(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        return namespace + ":svc_itc:" + serviceId + "@*";
    }

    @JvmStatic
    @NotNull
    public static final String getInstanceIdOfKey(@NotNull String namespace, @NotNull String instanceKey) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)instanceKey, (String)"instanceKey");
        String instanceKeyPrefix = namespace + ":svc_itc:";
        String string = instanceKey.substring(instanceKeyPrefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }
}

