/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.RegistryProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceInstanceCodec;
import me.ahoo.cosky.discovery.ServiceRegistry;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J6\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J:\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120 H\u0016J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120#H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J&\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J&\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006("}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceRegistry;", "Lme/ahoo/cosky/discovery/ServiceRegistry;", "registryProperties", "Lme/ahoo/cosky/discovery/RegistryProperties;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "<init>", "(Lme/ahoo/cosky/discovery/RegistryProperties;Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;)V", "registeredEphemeralInstances", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/cosky/discovery/NamespacedInstanceId;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "getRegisteredEphemeralInstances", "()Ljava/util/concurrent/ConcurrentHashMap;", "registerInternal", "Lreactor/core/publisher/Mono;", "", "namespace", "", "serviceInstance", "setService", "serviceId", "removeService", "register", "addEphemeralInstance", "", "removeEphemeralInstance", "instanceId", "setMetadata", "key", "value", "metadata", "", "setMetadataInternal", "args", "", "renew", "deregister", "deregisterInternal", "Companion", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nRedisServiceRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisServiceRegistry.kt\nme/ahoo/cosky/discovery/redis/RedisServiceRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class RedisServiceRegistry
implements ServiceRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RegistryProperties registryProperties;
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;
    @NotNull
    private final ConcurrentHashMap<NamespacedInstanceId, ServiceInstance> registeredEphemeralInstances;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(RedisServiceRegistry::log$lambda$30);

    public RedisServiceRegistry(@NotNull RegistryProperties registryProperties, @NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)registryProperties, (String)"registryProperties");
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        this.registryProperties = registryProperties;
        this.redisTemplate = redisTemplate;
        this.registeredEphemeralInstances = new ConcurrentHashMap();
    }

    @NotNull
    public ConcurrentHashMap<NamespacedInstanceId, ServiceInstance> getRegisteredEphemeralInstances() {
        return this.registeredEphemeralInstances;
    }

    private final Mono<Boolean> registerInternal(String namespace, ServiceInstance serviceInstance) {
        List list;
        int argVCapacity = 6 + serviceInstance.getMetadata().size() * 2;
        List $this$registerInternal_u24lambda_u240 = list = CollectionsKt.createListBuilder((int)argVCapacity);
        boolean bl = false;
        $this$registerInternal_u24lambda_u240.add(serviceInstance.isEphemeral() ? String.valueOf(this.registryProperties.getInstanceTtl().getSeconds()) : "-1");
        $this$registerInternal_u24lambda_u240.add(serviceInstance.getServiceId());
        $this$registerInternal_u24lambda_u240.add(serviceInstance.getInstanceId());
        $this$registerInternal_u24lambda_u240.add(serviceInstance.getSchema());
        $this$registerInternal_u24lambda_u240.add(serviceInstance.getHost());
        $this$registerInternal_u24lambda_u240.add(String.valueOf(serviceInstance.getPort()));
        $this$registerInternal_u24lambda_u240.add(String.valueOf(serviceInstance.getWeight()));
        ServiceInstanceCodec.encodeMetadata($this$registerInternal_u24lambda_u240, serviceInstance.getMetadata());
        List values = CollectionsKt.build((List)list);
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_REGISTER(), CollectionsKt.listOf((Object)namespace), values).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> setService(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceRegistry$setService$32 = false;
            String $i$a$-require-RedisServiceRegistry$setService$32 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceRegistry$setService$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean bl = false;
            String string = "serviceId must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.info(() -> RedisServiceRegistry.setService$lambda$3(serviceId, namespace));
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_SET_SERVICE(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object)serviceId)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> removeService(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceRegistry$removeService$32 = false;
            String $i$a$-require-RedisServiceRegistry$removeService$32 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceRegistry$removeService$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean bl = false;
            String string = "serviceId must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.warn(() -> RedisServiceRegistry.removeService$lambda$6(serviceId, namespace));
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_REMOVE_SERVICE(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object)serviceId)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> register(@NotNull String namespace, @NotNull ServiceInstance serviceInstance) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.info(() -> RedisServiceRegistry.register$lambda$8(serviceInstance, namespace));
        Mono mono = this.registerInternal(namespace, serviceInstance).doOnSubscribe(arg_0 -> RedisServiceRegistry.register$lambda$10(arg_0 -> RedisServiceRegistry.register$lambda$9(this, namespace, serviceInstance, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSubscribe(...)");
        return mono;
    }

    private final void addEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        this.getRegisteredEphemeralInstances().put(new NamespacedInstanceId(namespace, serviceInstance.getInstanceId()), serviceInstance);
    }

    private final void removeEphemeralInstance(String namespace, String instanceId) {
        ((ConcurrentHashMap)this.getRegisteredEphemeralInstances()).remove(new NamespacedInstanceId(namespace, instanceId));
    }

    private final void removeEphemeralInstance(String namespace, ServiceInstance serviceInstance) {
        if (!serviceInstance.isEphemeral()) {
            return;
        }
        ((ConcurrentHashMap)this.getRegisteredEphemeralInstances()).remove(new NamespacedInstanceId(namespace, serviceInstance.getInstanceId()));
    }

    @Override
    @NotNull
    public Mono<Boolean> setMetadata(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object[] objectArray = new String[]{instanceId, ServiceInstanceCodec.INSTANCE.encodeMetadataKey(key), value};
        List values = CollectionsKt.listOf((Object[])objectArray);
        return this.setMetadataInternal(namespace, instanceId, values);
    }

    @Override
    @NotNull
    public Mono<Boolean> setMetadata(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId, @NotNull Map<String, String> metadata) {
        List list;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        int argVCapacity = 1 + metadata.size() * 2;
        List $this$setMetadata_u24lambda_u2411 = list = CollectionsKt.createListBuilder((int)argVCapacity);
        boolean bl = false;
        $this$setMetadata_u24lambda_u2411.add(instanceId);
        ServiceInstanceCodec.encodeMetadata($this$setMetadata_u24lambda_u2411, metadata);
        List values = CollectionsKt.build((List)list);
        return this.setMetadataInternal(namespace, instanceId, values);
    }

    private final Mono<Boolean> setMetadataInternal(String namespace, String instanceId, List<String> args) {
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceRegistry$setMetadataInternal$32 = false;
            String $i$a$-require-RedisServiceRegistry$setMetadataInternal$32 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceRegistry$setMetadataInternal$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)instanceId))) {
            boolean bl = false;
            String string = "instanceId must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.info(() -> RedisServiceRegistry.setMetadataInternal$lambda$14(instanceId, namespace));
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_SET_METADATA(), CollectionsKt.listOf((Object)namespace), args).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> renew(@NotNull String namespace, @NotNull ServiceInstance serviceInstance) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.debug(() -> RedisServiceRegistry.renew$lambda$16(serviceInstance, namespace));
        if (!serviceInstance.isEphemeral()) {
            log.warn(() -> RedisServiceRegistry.renew$lambda$17(serviceInstance, namespace));
            return MonoExtensionsKt.toMono((Object)false);
        }
        Object[] objectArray = new String[]{serviceInstance.getInstanceId(), String.valueOf(this.registryProperties.getInstanceTtl().getSeconds())};
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_RENEW(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object[])objectArray)).flatMap(arg_0 -> RedisServiceRegistry.renew$lambda$20(arg_0 -> RedisServiceRegistry.renew$lambda$19(this, namespace, serviceInstance, arg_0), arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> deregister(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        log.info(() -> RedisServiceRegistry.deregister$lambda$21(instanceId, namespace));
        Mono mono = this.deregisterInternal(namespace, serviceId, instanceId).doOnSubscribe(arg_0 -> RedisServiceRegistry.deregister$lambda$23(arg_0 -> RedisServiceRegistry.deregister$lambda$22(this, namespace, instanceId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSubscribe(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Boolean> deregister(@NotNull String namespace, @NotNull ServiceInstance serviceInstance) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        log.info(() -> RedisServiceRegistry.deregister$lambda$24(serviceInstance, namespace));
        Mono mono = this.deregisterInternal(namespace, serviceInstance.getServiceId(), serviceInstance.getInstanceId()).doOnSubscribe(arg_0 -> RedisServiceRegistry.deregister$lambda$26(arg_0 -> RedisServiceRegistry.deregister$lambda$25(this, namespace, serviceInstance, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSubscribe(...)");
        return mono;
    }

    private final Mono<Boolean> deregisterInternal(String namespace, String serviceId, String instanceId) {
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-RedisServiceRegistry$deregisterInternal$42 = false;
            String $i$a$-require-RedisServiceRegistry$deregisterInternal$42 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceRegistry$deregisterInternal$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean $i$a$-require-RedisServiceRegistry$deregisterInternal$52 = false;
            String $i$a$-require-RedisServiceRegistry$deregisterInternal$52 = "serviceId must not be blank!";
            throw new IllegalArgumentException($i$a$-require-RedisServiceRegistry$deregisterInternal$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)instanceId))) {
            boolean bl = false;
            String string = "instanceId must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new String[]{serviceId, instanceId};
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_REGISTRY_DEREGISTER(), CollectionsKt.listOf((Object)namespace), CollectionsKt.listOf((Object[])objectArray)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    private static final Object setService$lambda$3(String $serviceId, String $namespace) {
        return "Set Service - serviceId:[" + $serviceId + "]  @ namespace:[" + $namespace + "].";
    }

    private static final Object removeService$lambda$6(String $serviceId, String $namespace) {
        return "Remove Service - serviceId:[" + $serviceId + "]  @ namespace:[" + $namespace + "].";
    }

    private static final Object register$lambda$8(ServiceInstance $serviceInstance, String $namespace) {
        return "Register - instanceId:[" + $serviceInstance.getInstanceId() + "]  @ namespace:[" + $namespace + "].";
    }

    private static final Unit register$lambda$9(RedisServiceRegistry this$0, String $namespace, ServiceInstance $serviceInstance, Subscription it) {
        this$0.addEphemeralInstance($namespace, $serviceInstance);
        return Unit.INSTANCE;
    }

    private static final void register$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object setMetadataInternal$lambda$14(String $instanceId, String $namespace) {
        return "Set Metadata - instanceId:[" + $instanceId + "] @ namespace:[" + $namespace + "].";
    }

    private static final Object renew$lambda$16(ServiceInstance $serviceInstance, String $namespace) {
        return "Renew - instanceId:[" + $serviceInstance.getInstanceId() + "] @ namespace:[" + $namespace + "].";
    }

    private static final Object renew$lambda$17(ServiceInstance $serviceInstance, String $namespace) {
        return "Renew - instanceId:[" + $serviceInstance.getInstanceId() + "] @ namespace:[" + $namespace + "] is not ephemeral, can not renew.";
    }

    private static final Object renew$lambda$19$lambda$18(ServiceInstance $serviceInstance, String $namespace, Long $status) {
        return "Renew - instanceId:[" + $serviceInstance.getInstanceId() + "] @ namespace:[" + $namespace + "] status is [" + $status + "],register again.";
    }

    private static final Publisher renew$lambda$19(RedisServiceRegistry this$0, String $namespace, ServiceInstance $serviceInstance, Long status) {
        if (status <= 0L) {
            log.warn(() -> RedisServiceRegistry.renew$lambda$19$lambda$18($serviceInstance, $namespace, status));
            return (Publisher)this$0.register($namespace, $serviceInstance);
        }
        return (Publisher)MonoExtensionsKt.toMono((Object)true);
    }

    private static final Publisher renew$lambda$20(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Object deregister$lambda$21(String $instanceId, String $namespace) {
        return "Deregister - instanceId:[" + $instanceId + "] @ namespace:[" + $namespace + "].";
    }

    private static final Unit deregister$lambda$22(RedisServiceRegistry this$0, String $namespace, String $instanceId, Subscription it) {
        this$0.removeEphemeralInstance($namespace, $instanceId);
        return Unit.INSTANCE;
    }

    private static final void deregister$lambda$23(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object deregister$lambda$24(ServiceInstance $serviceInstance, String $namespace) {
        return "Deregister - instanceId:[" + $serviceInstance.getInstanceId() + "] @ namespace:[" + $namespace + "].";
    }

    private static final Unit deregister$lambda$25(RedisServiceRegistry this$0, String $namespace, ServiceInstance $serviceInstance, Subscription it) {
        this$0.removeEphemeralInstance($namespace, $serviceInstance);
        return Unit.INSTANCE;
    }

    private static final void deregister$lambda$26(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit log$lambda$30() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceRegistry$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

