/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.Instance;
import me.ahoo.cosky.discovery.ServiceInstance;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0018H\u0007J\u0014\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/ahoo/cosky/discovery/ServiceInstanceCodec;", "", "<init>", "()V", "SYSTEM_METADATA_PREFIX", "", "METADATA_PREFIX", "METADATA_PREFIX_LENGTH", "", "INSTANCE_ID", "SERVICE_ID", "SCHEMA", "HOST", "PORT", "WEIGHT", "EPHEMERAL", "TTL_AT", "encodeMetadataKey", "key", "decodeMetadataKey", "encodeMetadata", "", "preArgs", "instanceMetadata", "", "decode", "Lme/ahoo/cosky/discovery/ServiceInstance;", "instanceData", "", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nServiceInstanceCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceInstanceCodec.kt\nme/ahoo/cosky/discovery/ServiceInstanceCodec\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n216#2,2:142\n1#3:144\n*S KotlinDebug\n*F\n+ 1 ServiceInstanceCodec.kt\nme/ahoo/cosky/discovery/ServiceInstanceCodec\n*L\n49#1:142,2\n*E\n"})
public final class ServiceInstanceCodec {
    @NotNull
    public static final ServiceInstanceCodec INSTANCE = new ServiceInstanceCodec();
    @NotNull
    private static final String SYSTEM_METADATA_PREFIX = "__";
    @NotNull
    private static final String METADATA_PREFIX = "_";
    private static final int METADATA_PREFIX_LENGTH = 1;
    @NotNull
    private static final String INSTANCE_ID = "instanceId";
    @NotNull
    private static final String SERVICE_ID = "serviceId";
    @NotNull
    private static final String SCHEMA = "schema";
    @NotNull
    private static final String HOST = "host";
    @NotNull
    private static final String PORT = "port";
    @NotNull
    private static final String WEIGHT = "weight";
    @NotNull
    private static final String EPHEMERAL = "ephemeral";
    @NotNull
    private static final String TTL_AT = "ttl_at";

    private ServiceInstanceCodec() {
    }

    @NotNull
    public final String encodeMetadataKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return METADATA_PREFIX + key;
    }

    @NotNull
    public final String decodeMetadataKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final List<String> encodeMetadata(@NotNull List<String> preArgs, @NotNull Map<String, String> instanceMetadata) {
        Intrinsics.checkNotNullParameter(preArgs, (String)"preArgs");
        Intrinsics.checkNotNullParameter(instanceMetadata, (String)"instanceMetadata");
        if (instanceMetadata.isEmpty()) {
            return preArgs;
        }
        Map<String, String> $this$forEach$iv = instanceMetadata;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            preArgs.add(INSTANCE.encodeMetadataKey(it.getKey()));
            preArgs.add(it.getValue());
        }
        return preArgs;
    }

    @NotNull
    public final ServiceInstance decode(@NotNull List<String> instanceData) {
        Intrinsics.checkNotNullParameter(instanceData, (String)"instanceData");
        String instanceId = null;
        String serviceId = null;
        String schema = null;
        String host = null;
        Integer port = null;
        Integer weight = null;
        Boolean isEphemeral = null;
        Long ttlAt = null;
        Map metadata = new LinkedHashMap();
        block20: for (int i = 0; i < instanceData.size(); i += 2) {
            String key = instanceData.get(i);
            String value = instanceData.get(i + 1);
            switch (key) {
                case "instanceId": {
                    instanceId = value;
                    continue block20;
                }
                case "serviceId": {
                    serviceId = value;
                    continue block20;
                }
                case "schema": {
                    schema = value;
                    continue block20;
                }
                case "host": {
                    host = value;
                    continue block20;
                }
                case "port": {
                    port = Integer.parseInt(value);
                    continue block20;
                }
                case "weight": {
                    weight = Integer.parseInt(value);
                    continue block20;
                }
                case "ephemeral": {
                    isEphemeral = Boolean.parseBoolean(value);
                    continue block20;
                }
                case "ttl_at": {
                    ttlAt = Long.parseLong(value);
                    continue block20;
                }
                default: {
                    if (!StringsKt.startsWith$default((String)key, (String)METADATA_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)SYSTEM_METADATA_PREFIX, (boolean)false, (int)2, null)) continue block20;
                    String metadataKey = this.decodeMetadataKey(key);
                    metadata.put(metadataKey, value);
                }
            }
        }
        if (serviceId == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$92 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$92 = "serviceId is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$92.toString());
        }
        if (schema == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$102 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$102 = "schema is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$102.toString());
        }
        if (host == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$112 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$112 = "host is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$112.toString());
        }
        if (port == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$122 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$122 = "port is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$122.toString());
        }
        if (instanceId == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$132 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$132 = "instanceId is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$132.toString());
        }
        Instance instance = Instance.Companion.asInstance(serviceId, schema, host, port, instanceId);
        if (weight == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$142 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$142 = "weight is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$142.toString());
        }
        if (isEphemeral == null) {
            boolean $i$a$-requireNotNull-ServiceInstanceCodec$decode$152 = false;
            String $i$a$-requireNotNull-ServiceInstanceCodec$decode$152 = "isEphemeral is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-ServiceInstanceCodec$decode$152.toString());
        }
        if (isEphemeral.booleanValue() && ttlAt == null) {
            boolean bl = false;
            String string = "ttlAt is null";
            throw new IllegalArgumentException(string.toString());
        }
        Long l = ttlAt;
        return ServiceInstance.Companion.asServiceInstance(instance, weight, isEphemeral, l != null ? l : -1L, metadata);
    }
}

