/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\u000e"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/RandomLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/AbstractLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/RandomLoadBalancer$RandomChooser;", "serviceDiscovery", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "<init>", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "createChooser", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "RandomChooser", "cosky-discovery"})
public final class RandomLoadBalancer
extends AbstractLoadBalancer<RandomChooser> {
    public RandomLoadBalancer(@NotNull ServiceDiscovery serviceDiscovery, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)serviceDiscovery, (String)"serviceDiscovery");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        super(serviceDiscovery, instanceEventListenerContainer);
    }

    @Override
    @NotNull
    protected RandomChooser createChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
        Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
        return new RandomChooser(serviceInstances);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/RandomLoadBalancer$RandomChooser;", "Lme/ahoo/cosky/discovery/loadbalancer/LoadBalancer$Chooser;", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Ljava/util/List;)V", "choose", "cosky-discovery"})
    public static final class RandomChooser
    implements LoadBalancer.Chooser {
        @NotNull
        private final List<ServiceInstance> serviceInstances;

        public RandomChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
            Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
            this.serviceInstances = serviceInstances;
        }

        @Override
        @Nullable
        public ServiceInstance choose() {
            if (this.serviceInstances.isEmpty()) {
                return null;
            }
            if (this.serviceInstances.size() == 1) {
                return this.serviceInstances.get(0);
            }
            int randomIdx = ThreadLocalRandom.current().nextInt(this.serviceInstances.size());
            return this.serviceInstances.get(randomIdx);
        }
    }
}

