/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.Instance;
import me.ahoo.cosky.discovery.InstanceChangedEvent;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.redis.ConsistencyRedisServiceDiscovery;
import me.ahoo.cosky.discovery.redis.NoOpHookOnResetInstanceCache;
import me.ahoo.cosky.discovery.redis.NoOpHookOnResetServiceCache;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#BK\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00122\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00160\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lme/ahoo/cosky/discovery/redis/ConsistencyRedisServiceDiscovery;", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "delegate", "serviceEventListenerContainer", "Lme/ahoo/cosky/discovery/ServiceEventListenerContainer;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "hookOnResetInstanceCache", "Lkotlin/Function1;", "Lme/ahoo/cosky/discovery/InstanceChangedEvent;", "", "hookOnResetServiceCache", "", "<init>", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/ServiceEventListenerContainer;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "serviceMapInstances", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/ahoo/cosky/discovery/NamespacedServiceId;", "Lreactor/core/publisher/Mono;", "Ljava/util/concurrent/CopyOnWriteArraySet;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "namespaceMapServices", "Lreactor/core/publisher/Flux;", "getServices", "namespace", "onServiceChanged", "getInstances", "serviceId", "getInstanceInternal", "instanceId", "getInstance", "getInstanceTtl", "", "onInstanceChanged", "instanceChangedEvent", "Companion", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nConsistencyRedisServiceDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsistencyRedisServiceDiscovery.kt\nme/ahoo/cosky/discovery/redis/ConsistencyRedisServiceDiscovery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1#2:215\n295#3,2:216\n*S KotlinDebug\n*F\n+ 1 ConsistencyRedisServiceDiscovery.kt\nme/ahoo/cosky/discovery/redis/ConsistencyRedisServiceDiscovery\n*L\n156#1:216,2\n*E\n"})
public final class ConsistencyRedisServiceDiscovery
implements ServiceDiscovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServiceDiscovery delegate;
    @NotNull
    private final ServiceEventListenerContainer serviceEventListenerContainer;
    @NotNull
    private final InstanceEventListenerContainer instanceEventListenerContainer;
    @NotNull
    private final Function1<InstanceChangedEvent, Unit> hookOnResetInstanceCache;
    @NotNull
    private final Function1<String, Unit> hookOnResetServiceCache;
    @NotNull
    private final ConcurrentHashMap<NamespacedServiceId, Mono<CopyOnWriteArraySet<ServiceInstance>>> serviceMapInstances;
    @NotNull
    private final ConcurrentHashMap<String, Flux<String>> namespaceMapServices;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(ConsistencyRedisServiceDiscovery::log$lambda$43);

    public ConsistencyRedisServiceDiscovery(@NotNull ServiceDiscovery delegate, @NotNull ServiceEventListenerContainer serviceEventListenerContainer, @NotNull InstanceEventListenerContainer instanceEventListenerContainer, @NotNull Function1<? super InstanceChangedEvent, Unit> hookOnResetInstanceCache, @NotNull Function1<? super String, Unit> hookOnResetServiceCache) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)serviceEventListenerContainer, (String)"serviceEventListenerContainer");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        Intrinsics.checkNotNullParameter(hookOnResetInstanceCache, (String)"hookOnResetInstanceCache");
        Intrinsics.checkNotNullParameter(hookOnResetServiceCache, (String)"hookOnResetServiceCache");
        this.delegate = delegate;
        this.serviceEventListenerContainer = serviceEventListenerContainer;
        this.instanceEventListenerContainer = instanceEventListenerContainer;
        this.hookOnResetInstanceCache = hookOnResetInstanceCache;
        this.hookOnResetServiceCache = hookOnResetServiceCache;
        this.serviceMapInstances = new ConcurrentHashMap();
        this.namespaceMapServices = new ConcurrentHashMap();
    }

    public /* synthetic */ ConsistencyRedisServiceDiscovery(ServiceDiscovery serviceDiscovery, ServiceEventListenerContainer serviceEventListenerContainer, InstanceEventListenerContainer instanceEventListenerContainer, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = NoOpHookOnResetInstanceCache.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function12 = NoOpHookOnResetServiceCache.INSTANCE;
        }
        this(serviceDiscovery, serviceEventListenerContainer, instanceEventListenerContainer, (Function1<? super InstanceChangedEvent, Unit>)function1, (Function1<? super String, Unit>)function12);
    }

    @Override
    @NotNull
    public Flux<String> getServices(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Flux flux = this.namespaceMapServices.computeIfAbsent(namespace, arg_0 -> ConsistencyRedisServiceDiscovery.getServices$lambda$6(arg_0 -> ConsistencyRedisServiceDiscovery.getServices$lambda$5(this, namespace, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"computeIfAbsent(...)");
        return flux;
    }

    private final void onServiceChanged(String namespace) {
        log.debug(() -> ConsistencyRedisServiceDiscovery.onServiceChanged$lambda$7(namespace));
        ((Map)this.namespaceMapServices).put(namespace, this.delegate.getServices(namespace).cache());
        this.hookOnResetServiceCache.invoke((Object)namespace);
    }

    @Override
    @NotNull
    public Flux<ServiceInstance> getInstances(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-ConsistencyRedisServiceDiscovery$getInstances$32 = false;
            String $i$a$-require-ConsistencyRedisServiceDiscovery$getInstances$32 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-ConsistencyRedisServiceDiscovery$getInstances$32.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean bl = false;
            String string = "serviceId must not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Flux flux = this.serviceMapInstances.computeIfAbsent(new NamespacedServiceId(namespace, serviceId), arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$17(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16(this, namespace, serviceId, arg_0), arg_0)).flatMapIterable(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$19(ConsistencyRedisServiceDiscovery::getInstances$lambda$18, arg_0)).filter(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$21(ConsistencyRedisServiceDiscovery::getInstances$lambda$20, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"filter(...)");
        return flux;
    }

    private final Mono<ServiceInstance> getInstanceInternal(String namespace, String serviceId, String instanceId) {
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$42 = false;
            String $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$42 = "namespace must not be blank!";
            throw new IllegalArgumentException($i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$42.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)serviceId))) {
            boolean $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$52 = false;
            String $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$52 = "serviceId must not be blank!";
            throw new IllegalArgumentException($i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$52.toString());
        }
        if (!(!StringsKt.isBlank((CharSequence)instanceId))) {
            boolean $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$62 = false;
            String $i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$62 = "instanceId must not be blank!";
            throw new IllegalArgumentException($i$a$-require-ConsistencyRedisServiceDiscovery$getInstanceInternal$62.toString());
        }
        NamespacedServiceId namespacedServiceId = new NamespacedServiceId(namespace, serviceId);
        Mono<CopyOnWriteArraySet<ServiceInstance>> mono = this.serviceMapInstances.get(namespacedServiceId);
        if (mono == null) {
            return this.delegate.getInstance(namespace, serviceId, instanceId);
        }
        Mono<CopyOnWriteArraySet<ServiceInstance>> instancesMono = mono;
        Mono mono2 = instancesMono.flatMapIterable(Function.identity()).switchIfEmpty((Publisher)this.delegate.getInstance(namespace, serviceId, instanceId)).filter(arg_0 -> ConsistencyRedisServiceDiscovery.getInstanceInternal$lambda$26(arg_0 -> ConsistencyRedisServiceDiscovery.getInstanceInternal$lambda$25(instanceId, arg_0), arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"next(...)");
        return mono2;
    }

    @Override
    @NotNull
    public Mono<ServiceInstance> getInstance(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        return this.getInstanceInternal(namespace, serviceId, instanceId);
    }

    @Override
    @NotNull
    public Mono<Long> getInstanceTtl(@NotNull String namespace, @NotNull String serviceId, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        Mono mono = this.getInstanceInternal(namespace, serviceId, instanceId).map(arg_0 -> ConsistencyRedisServiceDiscovery.getInstanceTtl$lambda$27((Function1)getInstanceTtl.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private final void onInstanceChanged(InstanceChangedEvent instanceChangedEvent) {
        log.debug(() -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$28(instanceChangedEvent));
        NamespacedServiceId namespacedServiceId = instanceChangedEvent.getNamespacedServiceId();
        Instance instance = instanceChangedEvent.getInstance();
        String instanceId = instance.getInstanceId();
        String namespace = namespacedServiceId.getNamespace();
        String serviceId = namespacedServiceId.getServiceId();
        Mono<CopyOnWriteArraySet<ServiceInstance>> instancesMono = this.serviceMapInstances.get(namespacedServiceId);
        if (instancesMono == null) {
            log.debug(() -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$29(instance, instanceChangedEvent));
            return;
        }
        instancesMono.flatMap(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$41(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40(instanceChangedEvent, this, namespace, serviceId, instanceId, instance, arg_0), arg_0)).doFinally(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$42(this, instanceChangedEvent, arg_0)).subscribe();
    }

    private static final Unit getServices$lambda$5$lambda$1(ConsistencyRedisServiceDiscovery this$0, String it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.onServiceChanged(it);
        return Unit.INSTANCE;
    }

    private static final void getServices$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object getServices$lambda$5$lambda$4$lambda$3(String $namespace, SignalType $it) {
        return "Listen topic[" + $namespace + "] finally - [" + $it + "].";
    }

    private static final void getServices$lambda$5$lambda$4(ConsistencyRedisServiceDiscovery this$0, String $namespace, SignalType it) {
        log.info(() -> ConsistencyRedisServiceDiscovery.getServices$lambda$5$lambda$4$lambda$3($namespace, it));
        this$0.namespaceMapServices.remove($namespace);
    }

    private static final Flux getServices$lambda$5(ConsistencyRedisServiceDiscovery this$0, String $namespace, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.serviceEventListenerContainer.receive($namespace).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.getServices$lambda$5$lambda$2(arg_0 -> ConsistencyRedisServiceDiscovery.getServices$lambda$5$lambda$1(this$0, arg_0), arg_0)).doFinally(arg_0 -> ConsistencyRedisServiceDiscovery.getServices$lambda$5$lambda$4(this$0, $namespace, arg_0)).subscribe();
        return this$0.delegate.getServices($namespace).cache();
    }

    private static final Flux getServices$lambda$6(Function1 $tmp0, Object p0) {
        return (Flux)$tmp0.invoke(p0);
    }

    private static final Object onServiceChanged$lambda$7(String $namespace) {
        return "onServiceChanged:" + $namespace;
    }

    private static final Unit getInstances$lambda$16$lambda$10(ConsistencyRedisServiceDiscovery this$0, InstanceChangedEvent it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.onInstanceChanged(it);
        return Unit.INSTANCE;
    }

    private static final void getInstances$lambda$16$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object getInstances$lambda$16$lambda$13$lambda$12(NamespacedServiceId $svcId, SignalType $it) {
        return "Listen topic[" + $svcId + "] finally - [" + $it + "].";
    }

    private static final void getInstances$lambda$16$lambda$13(ConsistencyRedisServiceDiscovery this$0, NamespacedServiceId $svcId, SignalType it) {
        log.info(() -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16$lambda$13$lambda$12($svcId, it));
        this$0.serviceMapInstances.remove($svcId);
    }

    private static final CopyOnWriteArraySet getInstances$lambda$16$lambda$14(List it) {
        return new CopyOnWriteArraySet(it);
    }

    private static final CopyOnWriteArraySet getInstances$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        return (CopyOnWriteArraySet)$tmp0.invoke(p0);
    }

    private static final Mono getInstances$lambda$16(ConsistencyRedisServiceDiscovery this$0, String $namespace, String $serviceId, NamespacedServiceId svcId) {
        Intrinsics.checkNotNullParameter((Object)svcId, (String)"svcId");
        this$0.instanceEventListenerContainer.receive(svcId).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16$lambda$11(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16$lambda$10(this$0, arg_0), arg_0)).doFinally(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16$lambda$13(this$0, svcId, arg_0)).subscribe();
        return this$0.delegate.getInstances($namespace, $serviceId).collectList().map(arg_0 -> ConsistencyRedisServiceDiscovery.getInstances$lambda$16$lambda$15(ConsistencyRedisServiceDiscovery::getInstances$lambda$16$lambda$14, arg_0)).cache();
    }

    private static final Mono getInstances$lambda$17(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Iterable getInstances$lambda$18(CopyOnWriteArraySet it) {
        return it;
    }

    private static final Iterable getInstances$lambda$19(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean getInstances$lambda$20(ServiceInstance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return !instance.isExpired();
    }

    private static final boolean getInstances$lambda$21(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getInstanceInternal$lambda$25(String $instanceId, ServiceInstance it) {
        return Intrinsics.areEqual((Object)it.getInstanceId(), (Object)$instanceId);
    }

    private static final boolean getInstanceInternal$lambda$26(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Long getInstanceTtl$lambda$27(Function1 $tmp0, Object p0) {
        return (Long)$tmp0.invoke(p0);
    }

    private static final Object onInstanceChanged$lambda$28(InstanceChangedEvent $instanceChangedEvent) {
        return "onInstanceChanged - instance:[" + $instanceChangedEvent.getInstance() + "] - message:[" + $instanceChangedEvent.getEvent() + "]";
    }

    private static final Object onInstanceChanged$lambda$29(Instance $instance, InstanceChangedEvent $instanceChangedEvent) {
        return "onInstanceChanged - instance:[" + $instance + "] - event:[" + $instanceChangedEvent.getEvent() + "] instancesMono is null.";
    }

    private static final Object onInstanceChanged$lambda$40$lambda$31(Instance $instance, InstanceChangedEvent $instanceChangedEvent) {
        return "onInstanceChanged - instance:[" + $instance + "] - event:[" + $instanceChangedEvent.getEvent() + "] not found cached Instance.";
    }

    private static final Unit onInstanceChanged$lambda$40$lambda$32(CopyOnWriteArraySet $cachedInstances, ServiceInstance serviceInstance) {
        Intrinsics.checkNotNullParameter((Object)serviceInstance, (String)"serviceInstance");
        $cachedInstances.add(serviceInstance);
        return Unit.INSTANCE;
    }

    private static final void onInstanceChanged$lambda$40$lambda$33(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit onInstanceChanged$lambda$40$lambda$34(CopyOnWriteArraySet $cachedInstances, ServiceInstance $cachedInstance, ServiceInstance registeredInstance) {
        Intrinsics.checkNotNullParameter((Object)registeredInstance, (String)"registeredInstance");
        $cachedInstances.remove($cachedInstance);
        $cachedInstances.add(registeredInstance);
        return Unit.INSTANCE;
    }

    private static final void onInstanceChanged$lambda$40$lambda$35(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit onInstanceChanged$lambda$40$lambda$36(CopyOnWriteArraySet $cachedInstances, ServiceInstance $cachedInstance, Long ttlAt) {
        $cachedInstances.remove($cachedInstance);
        Intrinsics.checkNotNull((Object)ttlAt);
        $cachedInstances.add(ServiceInstance.Companion.withTtlAt($cachedInstance, ttlAt));
        return Unit.INSTANCE;
    }

    private static final void onInstanceChanged$lambda$40$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit onInstanceChanged$lambda$40$lambda$38(CopyOnWriteArraySet $cachedInstances, ServiceInstance $cachedInstance, ServiceInstance updatedInstance) {
        $cachedInstances.remove($cachedInstance);
        $cachedInstances.add(updatedInstance);
        return Unit.INSTANCE;
    }

    private static final void onInstanceChanged$lambda$40$lambda$39(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Mono onInstanceChanged$lambda$40(InstanceChangedEvent $instanceChangedEvent, ConsistencyRedisServiceDiscovery this$0, String $namespace, String $serviceId, String $instanceId, Instance $instance, CopyOnWriteArraySet cachedInstances) {
        ServiceInstance cachedInstance;
        ServiceInstance serviceInstance;
        Object v0;
        block10: {
            Intrinsics.checkNotNullParameter((Object)cachedInstances, (String)"cachedInstances");
            Iterable $this$firstOrNull$iv = cachedInstances;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ServiceInstance it = (ServiceInstance)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInstanceId(), (Object)$instanceId)) continue;
                v0 = element$iv;
                break block10;
            }
            v0 = null;
        }
        if ((serviceInstance = (ServiceInstance)v0) == null) {
            serviceInstance = cachedInstance = ServiceInstance.Companion.getNOT_FOUND();
        }
        if (Intrinsics.areEqual((Object)ServiceInstance.Companion.getNOT_FOUND(), (Object)cachedInstance)) {
            if (InstanceChangedEvent.Event.REGISTER != $instanceChangedEvent.getEvent() && InstanceChangedEvent.Event.RENEW != $instanceChangedEvent.getEvent()) {
                log.debug(() -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$31($instance, $instanceChangedEvent));
                return Mono.empty();
            }
            return this$0.delegate.getInstance($namespace, $serviceId, $instanceId).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$33(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$32(cachedInstances, arg_0), arg_0));
        }
        switch (WhenMappings.$EnumSwitchMapping$0[$instanceChangedEvent.getEvent().ordinal()]) {
            case 1: {
                return this$0.delegate.getInstance($namespace, $serviceId, $instanceId).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$35(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$34(cachedInstances, cachedInstance, arg_0), arg_0));
            }
            case 2: {
                return this$0.delegate.getInstanceTtl($namespace, $serviceId, $instanceId).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$37(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$36(cachedInstances, cachedInstance, arg_0), arg_0));
            }
            case 3: {
                return this$0.delegate.getInstance($namespace, $serviceId, $instanceId).doOnNext(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$39(arg_0 -> ConsistencyRedisServiceDiscovery.onInstanceChanged$lambda$40$lambda$38(cachedInstances, cachedInstance, arg_0), arg_0));
            }
            case 4: 
            case 5: {
                cachedInstances.remove(cachedInstance);
                return Mono.empty();
            }
        }
        return MonoExtensionsKt.toMono((Throwable)new IllegalStateException("Unexpected value: " + $instanceChangedEvent.getEvent()));
    }

    private static final Mono onInstanceChanged$lambda$41(Function1 $tmp0, Object p0) {
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void onInstanceChanged$lambda$42(ConsistencyRedisServiceDiscovery this$0, InstanceChangedEvent $instanceChangedEvent, SignalType it) {
        this$0.hookOnResetInstanceCache.invoke((Object)$instanceChangedEvent);
    }

    private static final Unit log$lambda$43() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/redis/ConsistencyRedisServiceDiscovery$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InstanceChangedEvent.Event.values().length];
            try {
                nArray[InstanceChangedEvent.Event.REGISTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstanceChangedEvent.Event.RENEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstanceChangedEvent.Event.SET_METADATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstanceChangedEvent.Event.DEREGISTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InstanceChangedEvent.Event.EXPIRED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

