/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.ahoo.cosky.core.redis.RedisEventListenerContainer;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.Instance;
import me.ahoo.cosky.discovery.InstanceChangedEvent;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceTopology;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Subscription;
import org.springframework.data.redis.connection.ReactiveSubscription;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.ReactiveRedisMessageListenerContainer;
import reactor.core.publisher.Flux;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u001c\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisInstanceEventListenerContainer;", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "Lme/ahoo/cosky/core/redis/RedisEventListenerContainer;", "Lme/ahoo/cosky/discovery/NamespacedServiceId;", "Lme/ahoo/cosky/discovery/InstanceChangedEvent;", "delegate", "Lorg/springframework/data/redis/listener/ReactiveRedisMessageListenerContainer;", "serviceTopology", "Lme/ahoo/cosky/discovery/ServiceTopology;", "<init>", "(Lorg/springframework/data/redis/listener/ReactiveRedisMessageListenerContainer;Lme/ahoo/cosky/discovery/ServiceTopology;)V", "receiveEvent", "Lreactor/core/publisher/Flux;", "topic", "asEvent", "message", "Lorg/springframework/data/redis/connection/ReactiveSubscription$Message;", "", "cosky-discovery"})
public final class RedisInstanceEventListenerContainer
extends RedisEventListenerContainer<NamespacedServiceId, InstanceChangedEvent>
implements InstanceEventListenerContainer {
    @NotNull
    private final ServiceTopology serviceTopology;

    public RedisInstanceEventListenerContainer(@NotNull ReactiveRedisMessageListenerContainer delegate, @NotNull ServiceTopology serviceTopology) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)serviceTopology, (String)"serviceTopology");
        super(delegate);
        this.serviceTopology = serviceTopology;
    }

    public /* synthetic */ RedisInstanceEventListenerContainer(ReactiveRedisMessageListenerContainer reactiveRedisMessageListenerContainer, ServiceTopology serviceTopology, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serviceTopology = ServiceTopology.Companion.getNO_OP();
        }
        this(reactiveRedisMessageListenerContainer, serviceTopology);
    }

    @NotNull
    protected Flux<InstanceChangedEvent> receiveEvent(@NotNull NamespacedServiceId topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        String instancePattern = !StringsKt.isBlank((CharSequence)topic.getServiceId()) ? DiscoveryKeyGenerator.getInstanceKeyPatternOfService(topic.getNamespace(), topic.getServiceId()) : DiscoveryKeyGenerator.getInstanceKeyPatternOfNamespace(topic.getNamespace());
        PatternTopic[] patternTopicArray = new PatternTopic[]{PatternTopic.of((String)instancePattern)};
        Flux flux = this.getDelegate().receive(patternTopicArray).map(arg_0 -> RedisInstanceEventListenerContainer.receiveEvent$lambda$1(arg_0 -> RedisInstanceEventListenerContainer.receiveEvent$lambda$0(this, arg_0), arg_0)).doOnSubscribe(arg_0 -> RedisInstanceEventListenerContainer.receiveEvent$lambda$3(arg_0 -> RedisInstanceEventListenerContainer.receiveEvent$lambda$2(topic, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnSubscribe(...)");
        return flux;
    }

    private final InstanceChangedEvent asEvent(ReactiveSubscription.Message<String, String> message) {
        Object object = message.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getChannel(...)");
        String namespace = DiscoveryKeyGenerator.getNamespaceOfKey((String)object);
        Object object2 = message.getChannel();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getChannel(...)");
        String instanceId = DiscoveryKeyGenerator.getInstanceIdOfKey(namespace, (String)object2);
        Instance instance = Instance.Companion.asInstance(instanceId);
        String serviceId = instance.getServiceId();
        NamespacedServiceId namespacedServiceId = new NamespacedServiceId(namespace, serviceId);
        Object object3 = message.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getMessage(...)");
        return new InstanceChangedEvent(namespacedServiceId, InstanceChangedEvent.Companion.asServiceChangedEvent((String)object3), instance);
    }

    private static final InstanceChangedEvent receiveEvent$lambda$0(RedisInstanceEventListenerContainer this$0, ReactiveSubscription.PatternMessage it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.asEvent((ReactiveSubscription.Message<String, String>)((ReactiveSubscription.Message)it));
    }

    private static final InstanceChangedEvent receiveEvent$lambda$1(Function1 $tmp0, Object p0) {
        return (InstanceChangedEvent)$tmp0.invoke(p0);
    }

    private static final Unit receiveEvent$lambda$2(NamespacedServiceId $topic, RedisInstanceEventListenerContainer this$0, Subscription it) {
        if (!StringsKt.isBlank((CharSequence)$topic.getServiceId())) {
            this$0.serviceTopology.addTopology($topic.getNamespace(), $topic.getServiceId()).subscribe();
        }
        return Unit.INSTANCE;
    }

    private static final void receiveEvent$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

