/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.ServiceInstanceContext;
import me.ahoo.cosky.discovery.ServiceTopology;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J(\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000e0\r0\u00072\u0006\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceTopology;", "Lme/ahoo/cosky/discovery/ServiceTopology;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "<init>", "(Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;)V", "addTopology", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "producerNamespace", "", "producerServiceId", "getTopology", "", "", "namespace", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nRedisServiceTopology.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisServiceTopology.kt\nme/ahoo/cosky/discovery/redis/RedisServiceTopology\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class RedisServiceTopology
implements ServiceTopology {
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;

    public RedisServiceTopology(@NotNull ReactiveStringRedisTemplate redisTemplate) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        this.redisTemplate = redisTemplate;
    }

    @Override
    @NotNull
    public Mono<Void> addTopology(@NotNull String producerNamespace, @NotNull String producerServiceId) {
        Mono mono;
        Intrinsics.checkNotNullParameter((Object)producerNamespace, (String)"producerNamespace");
        Intrinsics.checkNotNullParameter((Object)producerServiceId, (String)"producerServiceId");
        String consumerNamespace = ServiceInstanceContext.INSTANCE.getNamespace();
        String consumerName = ServiceTopology.Companion.getConsumerName();
        String producerName = ServiceTopology.Companion.getProducerName(producerNamespace, producerServiceId);
        if (Intrinsics.areEqual((Object)consumerName, (Object)producerName)) {
            Mono mono2 = Mono.empty();
            Intrinsics.checkNotNull((Object)mono2);
            mono = mono2;
        } else {
            Object[] objectArray = new String[]{consumerName, producerName};
            Mono mono3 = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_TOPOLOGY_ADD(), CollectionsKt.listOf((Object)consumerNamespace), CollectionsKt.listOf((Object[])objectArray)).then();
            Intrinsics.checkNotNull((Object)mono3);
            mono = mono3;
        }
        return mono;
    }

    @Override
    @NotNull
    public Mono<Map<String, Set<String>>> getTopology(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_SERVICE_TOPOLOGY_GET(), CollectionsKt.listOf((Object)namespace)).map(arg_0 -> RedisServiceTopology.getTopology$lambda$2(RedisServiceTopology::getTopology$lambda$1, arg_0)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    private static final Map getTopology$lambda$1(List it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        List deps = it;
        Map topology = new HashMap(deps.size());
        String consumerName = "";
        for (Object dep : deps) {
            if (dep instanceof String) {
                consumerName = ((String)dep).toString();
            }
            if (!(dep instanceof List)) continue;
            Map map = topology;
            HashSet hashSet = new HashSet((List)dep);
            map.put(consumerName, hashSet);
        }
        return topology;
    }

    private static final Map getTopology$lambda$2(Function1 $tmp0, Object p0) {
        return (Map)$tmp0.invoke(p0);
    }
}

