/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.NamespacedInstanceId;
import me.ahoo.cosky.discovery.NoOpConsumeRenewInstance;
import me.ahoo.cosky.discovery.RenewProperties;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.ServiceRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService;", "", "renewProperties", "Lme/ahoo/cosky/discovery/RenewProperties;", "serviceRegistry", "Lme/ahoo/cosky/discovery/ServiceRegistry;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "hookOnRenew", "Ljava/util/function/Consumer;", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Lme/ahoo/cosky/discovery/RenewProperties;Lme/ahoo/cosky/discovery/ServiceRegistry;Lreactor/core/scheduler/Scheduler;Ljava/util/function/Consumer;)V", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "renewCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "scheduleDisposable", "Lreactor/core/Disposable;", "start", "", "stop", "renew", "Companion", "cosky-discovery"})
public final class RenewInstanceService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RenewProperties renewProperties;
    @NotNull
    private final ServiceRegistry serviceRegistry;
    @NotNull
    private final Scheduler scheduler;
    @NotNull
    private final Consumer<ServiceInstance> hookOnRenew;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicInteger renewCounter;
    @Nullable
    private Disposable scheduleDisposable;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(RenewInstanceService::log$lambda$14);

    public RenewInstanceService(@NotNull RenewProperties renewProperties, @NotNull ServiceRegistry serviceRegistry, @NotNull Scheduler scheduler, @NotNull Consumer<ServiceInstance> hookOnRenew) {
        Intrinsics.checkNotNullParameter((Object)renewProperties, (String)"renewProperties");
        Intrinsics.checkNotNullParameter((Object)serviceRegistry, (String)"serviceRegistry");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(hookOnRenew, (String)"hookOnRenew");
        this.renewProperties = renewProperties;
        this.serviceRegistry = serviceRegistry;
        this.scheduler = scheduler;
        this.hookOnRenew = hookOnRenew;
        this.running = new AtomicBoolean(false);
        this.renewCounter = new AtomicInteger();
    }

    public /* synthetic */ RenewInstanceService(RenewProperties renewProperties, ServiceRegistry serviceRegistry, Scheduler scheduler, Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Scheduler scheduler2 = Schedulers.newSingle((String)"CoSky-Renew", (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)scheduler2, (String)"newSingle(...)");
            scheduler = scheduler2;
        }
        if ((n & 8) != 0) {
            consumer = NoOpConsumeRenewInstance.INSTANCE;
        }
        this(renewProperties, serviceRegistry, scheduler, consumer);
    }

    public final void start() {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        log.info(RenewInstanceService::start$lambda$0);
        this.scheduleDisposable = this.scheduler.schedulePeriodically(() -> RenewInstanceService.start$lambda$1(this), this.renewProperties.getInitialDelay().getSeconds(), this.renewProperties.getPeriod().getSeconds(), TimeUnit.SECONDS);
    }

    public final void stop() {
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        log.info(RenewInstanceService::stop$lambda$2);
        Disposable disposable = this.scheduleDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.scheduler.dispose();
    }

    private final void renew() {
        int times = this.renewCounter.incrementAndGet();
        Map<NamespacedInstanceId, ServiceInstance> instances = this.serviceRegistry.getRegisteredEphemeralInstances();
        log.debug(() -> RenewInstanceService.renew$lambda$3(instances, times));
        if (instances.isEmpty()) {
            log.debug(() -> RenewInstanceService.renew$lambda$4(instances, times));
            return;
        }
        Flux.fromIterable((Iterable)instances.entrySet()).flatMap(arg_0 -> RenewInstanceService.renew$lambda$8(arg_0 -> RenewInstanceService.renew$lambda$7(this, arg_0), arg_0)).doOnError(arg_0 -> RenewInstanceService.renew$lambda$11(RenewInstanceService::renew$lambda$10, arg_0)).doOnComplete(() -> RenewInstanceService.renew$lambda$13(instances, times)).subscribe();
    }

    private static final Object start$lambda$0() {
        return "Start.";
    }

    private static final void start$lambda$1(RenewInstanceService this$0) {
        this$0.renew();
    }

    private static final Object stop$lambda$2() {
        return "Stop.";
    }

    private static final Object renew$lambda$3(Map $instances, int $times) {
        return "Renew - instances size:" + $instances.size() + " start - times@[" + $times + "] .";
    }

    private static final Object renew$lambda$4(Map $instances, int $times) {
        return "Renew - instances size:" + $instances.size() + " end - times@[" + $times + "] .";
    }

    private static final Unit renew$lambda$7$lambda$5(RenewInstanceService this$0, ServiceInstance $value, Boolean it) {
        this$0.hookOnRenew.accept($value);
        return Unit.INSTANCE;
    }

    private static final void renew$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Publisher renew$lambda$7(RenewInstanceService this$0, Map.Entry entry) {
        Intrinsics.checkNotNull((Object)entry);
        NamespacedInstanceId key = (NamespacedInstanceId)entry.getKey();
        ServiceInstance value = (ServiceInstance)entry.getValue();
        return (Publisher)this$0.serviceRegistry.renew(key.getNamespace(), value).doOnSuccess(arg_0 -> RenewInstanceService.renew$lambda$7$lambda$6(arg_0 -> RenewInstanceService.renew$lambda$7$lambda$5(this$0, value, arg_0), arg_0));
    }

    private static final Publisher renew$lambda$8(Function1 $tmp0, Object p0) {
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Object renew$lambda$10$lambda$9() {
        return "Renew - failed.";
    }

    private static final Unit renew$lambda$10(Throwable it) {
        log.warn(RenewInstanceService::renew$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final void renew$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Object renew$lambda$13$lambda$12(Map $instances, int $times) {
        return "Renew - instances size:" + $instances.size() + " end - times@[" + $times + "].";
    }

    private static final void renew$lambda$13(Map $instances, int $times) {
        log.debug(() -> RenewInstanceService.renew$lambda$13$lambda$12($instances, $times));
    }

    private static final Unit log$lambda$14() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/RenewInstanceService$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

