/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.loadbalancer;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.ServiceDiscovery;
import me.ahoo.cosky.discovery.ServiceInstance;
import me.ahoo.cosky.discovery.loadbalancer.AbstractLoadBalancer;
import me.ahoo.cosky.discovery.loadbalancer.LoadBalancer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014\u00a8\u0006\u000f"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/AbstractLoadBalancer;", "Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$BinaryChooser;", "serviceDiscovery", "Lme/ahoo/cosky/discovery/ServiceDiscovery;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "<init>", "(Lme/ahoo/cosky/discovery/ServiceDiscovery;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "createChooser", "serviceInstances", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "Companion", "BinaryChooser", "cosky-discovery"})
public final class BinaryWeightRandomLoadBalancer
extends AbstractLoadBalancer<BinaryChooser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(BinaryWeightRandomLoadBalancer::log$lambda$0);

    public BinaryWeightRandomLoadBalancer(@NotNull ServiceDiscovery serviceDiscovery, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)serviceDiscovery, (String)"serviceDiscovery");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        super(serviceDiscovery, instanceEventListenerContainer);
    }

    @Override
    @NotNull
    protected BinaryChooser createChooser(@NotNull List<? extends ServiceInstance> serviceInstances) {
        Intrinsics.checkNotNullParameter(serviceInstances, (String)"serviceInstances");
        return new BinaryChooser(serviceInstances);
    }

    private static final Unit log$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$BinaryChooser;", "Lme/ahoo/cosky/discovery/loadbalancer/LoadBalancer$Chooser;", "instanceList", "", "Lme/ahoo/cosky/discovery/ServiceInstance;", "<init>", "(Ljava/util/List;)V", "totalWeight", "", "randomBound", "weightLine", "", "maxLineIndex", "choose", "binarySearchLowIndex", "randomValue", "cosky-discovery"})
    public static final class BinaryChooser
    implements LoadBalancer.Chooser {
        @NotNull
        private final List<ServiceInstance> instanceList;
        private final int totalWeight;
        private final int randomBound;
        @NotNull
        private final int[] weightLine;
        private final int maxLineIndex;

        public BinaryChooser(@NotNull List<? extends ServiceInstance> instanceList) {
            Intrinsics.checkNotNullParameter(instanceList, (String)"instanceList");
            this.instanceList = instanceList;
            this.weightLine = new int[this.instanceList.size()];
            this.maxLineIndex = this.instanceList.size() - 1;
            int accWeight = 0;
            int n = ((Collection)this.instanceList).size();
            for (int i = 0; i < n; ++i) {
                int instanceWeight = this.instanceList.get(i).getWeight();
                if (instanceWeight == 0) continue;
                this.weightLine[i] = accWeight += instanceWeight;
            }
            this.totalWeight = accWeight;
            this.randomBound = this.totalWeight + 1;
        }

        @Override
        @Nullable
        public ServiceInstance choose() {
            if (this.weightLine.length == 0) {
                log.warn(BinaryChooser::choose$lambda$0);
                return null;
            }
            if (this.totalWeight == 0) {
                log.warn(() -> BinaryChooser.choose$lambda$1(this));
                return null;
            }
            if (this.weightLine.length == 1) {
                return this.instanceList.get(0);
            }
            int randomValue = ThreadLocalRandom.current().nextInt(1, this.randomBound);
            if (randomValue == 1) {
                return this.instanceList.get(0);
            }
            if (randomValue == this.totalWeight) {
                return this.instanceList.get(this.maxLineIndex);
            }
            int instanceIdx = this.binarySearchLowIndex(randomValue);
            return this.instanceList.get(instanceIdx);
        }

        private final int binarySearchLowIndex(int randomValue) {
            int idx = Arrays.binarySearch(this.weightLine, randomValue);
            if (idx < 0) {
                idx = -idx - 1;
            }
            return idx;
        }

        private static final Object choose$lambda$0() {
            return "choose - The size of connector instances is zero!";
        }

        private static final Object choose$lambda$1(BinaryChooser this$0) {
            return "choose - The size of connector instances is [" + this$0.weightLine.length + "],but total weight is 0!";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/loadbalancer/BinaryWeightRandomLoadBalancer$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

