/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosky.discovery.redis;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.ahoo.cosky.discovery.DiscoveryKeyGenerator;
import me.ahoo.cosky.discovery.InstanceChangedEvent;
import me.ahoo.cosky.discovery.InstanceEventListenerContainer;
import me.ahoo.cosky.discovery.NamespacedServiceId;
import me.ahoo.cosky.discovery.ServiceStat;
import me.ahoo.cosky.discovery.ServiceStatistic;
import me.ahoo.cosky.discovery.redis.DiscoveryRedisScripts;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.redis.core.ReactiveStringRedisTemplate;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0016J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceStatistic;", "Lme/ahoo/cosky/discovery/ServiceStatistic;", "redisTemplate", "Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;", "instanceEventListenerContainer", "Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;", "<init>", "(Lorg/springframework/data/redis/core/ReactiveStringRedisTemplate;Lme/ahoo/cosky/discovery/InstanceEventListenerContainer;)V", "listenedNamespaces", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lreactor/core/Disposable;", "startListeningServiceInstancesOfNamespace", "", "namespace", "instanceChanged", "event", "Lme/ahoo/cosky/discovery/InstanceChangedEvent;", "statService", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "serviceId", "statServiceInternal", "countService", "", "getServiceStats", "Lreactor/core/publisher/Flux;", "Lme/ahoo/cosky/discovery/ServiceStat;", "getInstanceCount", "Companion", "cosky-discovery"})
@SourceDebugExtension(value={"SMAP\nRedisServiceStatistic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisServiceStatistic.kt\nme/ahoo/cosky/discovery/redis/RedisServiceStatistic\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class RedisServiceStatistic
implements ServiceStatistic {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveStringRedisTemplate redisTemplate;
    @NotNull
    private final InstanceEventListenerContainer instanceEventListenerContainer;
    @NotNull
    private final ConcurrentHashMap<String, Disposable> listenedNamespaces;
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger(RedisServiceStatistic::log$lambda$11);

    public RedisServiceStatistic(@NotNull ReactiveStringRedisTemplate redisTemplate, @NotNull InstanceEventListenerContainer instanceEventListenerContainer) {
        Intrinsics.checkNotNullParameter((Object)redisTemplate, (String)"redisTemplate");
        Intrinsics.checkNotNullParameter((Object)instanceEventListenerContainer, (String)"instanceEventListenerContainer");
        this.redisTemplate = redisTemplate;
        this.instanceEventListenerContainer = instanceEventListenerContainer;
        this.listenedNamespaces = new ConcurrentHashMap();
    }

    private final void startListeningServiceInstancesOfNamespace(String namespace) {
        this.listenedNamespaces.computeIfAbsent(namespace, arg_0 -> RedisServiceStatistic.startListeningServiceInstancesOfNamespace$lambda$3(arg_0 -> RedisServiceStatistic.startListeningServiceInstancesOfNamespace$lambda$2(this, namespace, arg_0), arg_0));
    }

    private final void instanceChanged(InstanceChangedEvent event) {
        log.debug(() -> RedisServiceStatistic.instanceChanged$lambda$4(event));
        if (InstanceChangedEvent.Event.RENEW == event.getEvent()) {
            return;
        }
        this.statServiceInternal(event.getNamespacedServiceId().getNamespace(), event.getNamespacedServiceId().getServiceId()).subscribe();
    }

    @Override
    @NotNull
    public Mono<Void> statService(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.startListeningServiceInstancesOfNamespace(namespace);
        return this.statServiceInternal(namespace, null);
    }

    @Override
    @NotNull
    public Mono<Void> statService(@NotNull String namespace, @NotNull String serviceId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
        return this.statServiceInternal(namespace, serviceId);
    }

    private final Mono<Void> statServiceInternal(String namespace, String serviceId) {
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        log.debug(() -> RedisServiceStatistic.statServiceInternal$lambda$6(namespace));
        CharSequence charSequence = serviceId;
        List values = !(charSequence == null || charSequence.length() == 0) ? CollectionsKt.listOf((Object)serviceId) : CollectionsKt.emptyList();
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_SERVICE_STAT(), CollectionsKt.listOf((Object)namespace), values).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    @NotNull
    public final Mono<Long> countService(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        Mono mono = this.redisTemplate.opsForHash().size((Object)serviceIdxStatKey);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"size(...)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<ServiceStat> getServiceStats(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!(!StringsKt.isBlank((CharSequence)namespace))) {
            boolean bl = false;
            String string = "namespace can not be blank!";
            throw new IllegalArgumentException(string.toString());
        }
        String serviceIdxStatKey = DiscoveryKeyGenerator.getServiceStatKey(namespace);
        Flux flux = this.redisTemplate.opsForHash().entries((Object)serviceIdxStatKey).map(arg_0 -> RedisServiceStatistic.getServiceStats$lambda$10(RedisServiceStatistic::getServiceStats$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"map(...)");
        return flux;
    }

    @Override
    @NotNull
    public Mono<Long> getInstanceCount(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Mono mono = this.redisTemplate.execute(DiscoveryRedisScripts.INSTANCE.getSCRIPT_INSTANCE_COUNT_STAT(), CollectionsKt.listOf((Object)namespace)).next();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"next(...)");
        return mono;
    }

    private static final Unit startListeningServiceInstancesOfNamespace$lambda$2$lambda$0(RedisServiceStatistic this$0, InstanceChangedEvent it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.instanceChanged(it);
        return Unit.INSTANCE;
    }

    private static final void startListeningServiceInstancesOfNamespace$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Disposable startListeningServiceInstancesOfNamespace$lambda$2(RedisServiceStatistic this$0, String $namespace, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.instanceEventListenerContainer.receive(new NamespacedServiceId($namespace, "")).doOnNext(arg_0 -> RedisServiceStatistic.startListeningServiceInstancesOfNamespace$lambda$2$lambda$1(arg_0 -> RedisServiceStatistic.startListeningServiceInstancesOfNamespace$lambda$2$lambda$0(this$0, arg_0), arg_0)).subscribe();
    }

    private static final Disposable startListeningServiceInstancesOfNamespace$lambda$3(Function1 $tmp0, Object p0) {
        return (Disposable)$tmp0.invoke(p0);
    }

    private static final Object instanceChanged$lambda$4(InstanceChangedEvent $event) {
        return "instanceChanged - event:[" + $event + "]";
    }

    private static final Object statServiceInternal$lambda$6(String $namespace) {
        return "statService  @ namespace:[" + $namespace + "].";
    }

    private static final ServiceStat getServiceStats$lambda$9(Map.Entry entry) {
        Intrinsics.checkNotNull((Object)entry);
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        Intrinsics.checkNotNull((Object)key);
        Intrinsics.checkNotNull((Object)value);
        return new ServiceStat(key, Integer.parseInt(value));
    }

    private static final ServiceStat getServiceStats$lambda$10(Function1 $tmp0, Object p0) {
        return (ServiceStat)$tmp0.invoke(p0);
    }

    private static final Unit log$lambda$11() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/cosky/discovery/redis/RedisServiceStatistic$Companion;", "", "<init>", "()V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "cosky-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

