package me.ahoo.eventbus.rabbit;

import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import lombok.var;
import me.ahoo.eventbus.core.publisher.PublishEventWrapper;
import me.ahoo.eventbus.core.publisher.PublishException;
import me.ahoo.eventbus.core.publisher.Publisher;
import me.ahoo.eventbus.rabbit.config.RabbitConfig;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

/**
 * @author ahoo wang
 */
@Slf4j
public class RabbitPublisher implements Publisher, AutoCloseable {
    private final RabbitTemplate rabbitTemplate;

    @SneakyThrows
    public RabbitPublisher(RabbitConfig rabbitConfig, ConnectionFactory connectionFactory) {
        this.rabbitTemplate = new RabbitTemplate(connectionFactory);
        this.rabbitTemplate.setExchange(rabbitConfig.getExchange());
    }

    @SneakyThrows
    @Override
    public void publish(PublishEventWrapper publishEventWrapper) {
        try {
            var eventName = publishEventWrapper.getEventName();
            var message = EventCodecs.encode(publishEventWrapper);

            rabbitTemplate.send(eventName, message);
            log.info("publish eventWrapper:[{}] -> eventWrapper.id:[{}] ", eventName, publishEventWrapper.getId());
        } catch (Throwable throwable) {
            throw new PublishException(throwable);
        }
    }

    @Override
    public void close() throws Exception {
        log.info("closing resources!");
        rabbitTemplate.destroy();
    }
}
