/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import com.google.common.base.Charsets;
import me.ahoo.eventbus.core.publisher.PublishEventWrapper;
import me.ahoo.eventbus.core.subscriber.Subscriber;
import me.ahoo.eventbus.rabbit.EventCodecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class RabbitEventListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RabbitEventListener.class);
    private final Subscriber subscriber;

    public RabbitEventListener(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    public void onMessage(Message message) {
        try {
            PublishEventWrapper publishEventWrapper = EventCodecs.decode(message, this.subscriber.getSubscribeEventClass());
            log.info("received event subscriber:[{}]-> id:[{}] ,eventName:[{}].", new Object[]{this.subscriber.getName(), publishEventWrapper.getId(), publishEventWrapper.getEventName()});
            this.subscriber.invoke(publishEventWrapper);
        }
        catch (Throwable throwable) {
            String payloadStr = new String(message.getBody(), Charsets.UTF_8);
            log.error(String.format("received event ERROR -> routeKey:[%s] , payload: %n  %s", this.subscriber.getSubscribeEventName(), payloadStr), throwable);
        }
    }
}

