/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.eventbus.core.consistency.ConsistencySubscriber;
import me.ahoo.eventbus.core.consistency.ConsistencySubscriberFactory;
import me.ahoo.eventbus.core.subscriber.Subscriber;
import me.ahoo.eventbus.core.subscriber.SubscriberRegistry;
import me.ahoo.eventbus.rabbit.RabbitEventListener;
import me.ahoo.eventbus.rabbit.config.RabbitConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.config.DirectRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpointRegistry;

public class RabbitSubscriberRegistry
implements SubscriberRegistry {
    private static final Logger log = LoggerFactory.getLogger(RabbitSubscriberRegistry.class);
    private final ConsistencySubscriberFactory subscriberFactory;
    private final RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry;
    private final DirectRabbitListenerContainerFactory listenerContainerFactory;
    private final RabbitAdmin rabbitAdmin;
    private final Exchange exchange;
    private final ConcurrentHashMap<String, Subscriber> subscriberNameMap;

    public RabbitSubscriberRegistry(RabbitConfig rabbitConfig, ConnectionFactory connectionFactory, ConsistencySubscriberFactory subscriberFactory, RabbitListenerEndpointRegistry rabbitListenerEndpointRegistry) {
        this.exchange = ExchangeBuilder.directExchange((String)rabbitConfig.getExchange()).build();
        this.subscriberFactory = subscriberFactory;
        this.rabbitListenerEndpointRegistry = rabbitListenerEndpointRegistry;
        this.listenerContainerFactory = new DirectRabbitListenerContainerFactory();
        this.listenerContainerFactory.setConnectionFactory(connectionFactory);
        this.listenerContainerFactory.setContainerCustomizer(container -> {
            String listenerId = container.getListenerId();
            container.setBeanName(listenerId);
        });
        this.rabbitAdmin = new RabbitAdmin(connectionFactory);
        this.subscriberNameMap = new ConcurrentHashMap();
    }

    public void subscribe(Subscriber subscriber) {
        this.initSubscribeQueue(subscriber);
        ConsistencySubscriber consistencySubscriber = this.subscriberFactory.create(subscriber);
        this.registerListener((Subscriber)consistencySubscriber);
        this.registerSubscriber((Subscriber)consistencySubscriber);
    }

    private void initSubscribeQueue(Subscriber subscriber) {
        String queueName = subscriber.getName();
        Queue subscriberQueue = QueueBuilder.durable((String)queueName).build();
        this.rabbitAdmin.declareQueue(subscriberQueue);
        log.info("Bind Self {}-> QueueName:[{}],RouterKey:[{}]", new Object[]{this.exchange, queueName, queueName});
        Binding selfBinding = BindingBuilder.bind((Queue)subscriberQueue).to(this.exchange).with(queueName).noargs();
        this.rabbitAdmin.declareBinding(selfBinding);
        log.info("Bind {}-> QueueName:[{}],RouterKey:[{}]", new Object[]{this.exchange, queueName, subscriber.getSubscribeEventName()});
        Binding routingKeyBinding = BindingBuilder.bind((Queue)subscriberQueue).to(this.exchange).with(subscriber.getSubscribeEventName()).noargs();
        this.rabbitAdmin.declareBinding(routingKeyBinding);
    }

    private void registerListener(Subscriber subscriber) {
        RabbitEventListener eventListener = new RabbitEventListener(subscriber);
        SimpleRabbitListenerEndpoint endpoint = new SimpleRabbitListenerEndpoint();
        endpoint.setId(subscriber.getName());
        endpoint.setQueueNames(new String[]{subscriber.getName()});
        endpoint.setMessageListener((MessageListener)eventListener);
        this.rabbitListenerEndpointRegistry.registerListenerContainer((RabbitListenerEndpoint)endpoint, (RabbitListenerContainerFactory)this.listenerContainerFactory, true);
    }

    private void registerSubscriber(Subscriber subscriber) {
        this.subscriberNameMap.put(subscriber.getName(), subscriber);
    }

    public Subscriber getSubscriber(String subscriberName) {
        return this.subscriberNameMap.get(subscriberName);
    }
}

