package me.ahoo.eventbus.rabbit;

import com.google.common.base.Charsets;
import lombok.extern.slf4j.Slf4j;
import lombok.var;
import me.ahoo.eventbus.core.publisher.PublishEvent;
import me.ahoo.eventbus.core.subscriber.Subscriber;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

/**
 * @author ahoo wang
 */
@Slf4j
public class RabbitEventListener implements MessageListener {
    private final Subscriber subscriber;

    public RabbitEventListener(Subscriber subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onMessage(Message message) {
        try {
            PublishEvent publishEvent = EventCodecs.decode(message, subscriber.getSubscribeEventClass());
            log.info("received event subscriber:[{}]-> id:[{}] ,eventName:[{}].", subscriber.getName(), publishEvent.getId(), publishEvent.getEventName());
            this.subscriber.invoke(publishEvent);
        } catch (Throwable throwable) {
            var payloadStr = new String(message.getBody(), Charsets.UTF_8);
            log.error(String.format("received event ERROR -> routeKey:[%s] , payload: %n  %s", subscriber.getSubscribeEventName(), payloadStr), throwable);
        }
    }
}
