/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.util.Date;
import me.ahoo.eventbus.core.compensation.CompensationPublishEvent;
import me.ahoo.eventbus.core.publisher.PublishEvent;
import me.ahoo.eventbus.core.utils.Dates;
import me.ahoo.eventbus.core.utils.Jsons;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;

public abstract class EventCodecs {
    public static final String EVENT_ID = "event_id";
    public static final String EVENT_NAME = "event_name";
    public static final String EVENT_CREATE_TIME = "event_create_time";

    public static Message encode(PublishEvent publishEvent) {
        String eventName = publishEvent.getEventName();
        MessageProperties messageProperties = (MessageProperties)MessagePropertiesBuilder.newInstance().setHeaderIfAbsent(EVENT_ID, (Object)publishEvent.getId()).setHeaderIfAbsent(EVENT_NAME, (Object)eventName).setHeaderIfAbsent(EVENT_CREATE_TIME, (Object)Dates.of((LocalDateTime)publishEvent.getCreateTime())).build();
        byte[] eventBuff = publishEvent instanceof CompensationPublishEvent ? ((String)((CompensationPublishEvent)publishEvent).getEventData()).getBytes(Charsets.UTF_8) : Jsons.serialize((Object)publishEvent.getEventData());
        return MessageBuilder.withBody((byte[])eventBuff).andProperties(messageProperties).build();
    }

    public static PublishEvent decode(Message message, Class<?> eventDataClass) {
        MessageProperties messageProperties = message.getMessageProperties();
        Long eventId = (Long)messageProperties.getHeader(EVENT_ID);
        Preconditions.checkNotNull((Object)eventId, (String)"%s can not be null.", (Object)EVENT_ID);
        String eventName = (String)messageProperties.getHeader(EVENT_NAME);
        Preconditions.checkNotNull((Object)eventName, (String)"%s can not be null.", (Object)EVENT_NAME);
        Date eventCreateTimeDate = (Date)messageProperties.getHeader(EVENT_CREATE_TIME);
        Preconditions.checkNotNull((Object)eventCreateTimeDate, (String)"%s can not be null.", (Object)EVENT_CREATE_TIME);
        LocalDateTime eventCreateTime = Dates.of((Date)eventCreateTimeDate);
        Object typedEventData = Jsons.deserialize((byte[])message.getBody(), eventDataClass);
        return new PublishEvent(eventId, eventName, typedEventData, eventCreateTime);
    }
}

