/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import me.ahoo.eventbus.core.publisher.PublishEvent;
import me.ahoo.eventbus.core.publisher.PublishException;
import me.ahoo.eventbus.core.publisher.Publisher;
import me.ahoo.eventbus.rabbit.EventCodecs;
import me.ahoo.eventbus.rabbit.config.RabbitConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class RabbitPublisher
implements Publisher,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RabbitPublisher.class);
    private final RabbitTemplate rabbitTemplate;

    public RabbitPublisher(RabbitConfig rabbitConfig, ConnectionFactory connectionFactory) {
        this.rabbitTemplate = new RabbitTemplate(connectionFactory);
        this.rabbitTemplate.setExchange(rabbitConfig.getExchange());
    }

    public void publish(PublishEvent publishEvent) {
        try {
            String eventName = publishEvent.getEventName();
            Message message = EventCodecs.encode(publishEvent);
            this.rabbitTemplate.send(eventName, message);
            log.info("publish eventWrapper:[{}] -> eventWrapper.id:[{}] ", (Object)eventName, (Object)publishEvent.getId());
        }
        catch (Throwable throwable) {
            throw new PublishException(throwable);
        }
    }

    @Override
    public void close() throws Exception {
        log.info("closing resources!");
        this.rabbitTemplate.destroy();
    }
}

