/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import me.ahoo.eventbus.core.codec.EventCodec;
import me.ahoo.eventbus.core.compensate.CompensatePublishEvent;
import me.ahoo.eventbus.core.publisher.PublishEvent;
import me.ahoo.eventbus.core.serialize.Deserializer;
import me.ahoo.eventbus.core.serialize.Serializer;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.MessagePropertiesBuilder;

public class RabbitEventCodec
implements EventCodec {
    public static final String EVENT_ID = "event_id";
    public static final String EVENT_NAME = "event_name";
    public static final String EVENT_CREATE_TIME = "event_create_time";
    private final Serializer serializer;
    private final Deserializer deserializer;

    public RabbitEventCodec(Serializer serializer, Deserializer deserializer) {
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    public Message encode(PublishEvent publishEvent) {
        String eventName = publishEvent.getEventName();
        MessageProperties messageProperties = (MessageProperties)MessagePropertiesBuilder.newInstance().setHeaderIfAbsent(EVENT_ID, (Object)publishEvent.getId()).setHeaderIfAbsent(EVENT_NAME, (Object)eventName).setHeaderIfAbsent(EVENT_CREATE_TIME, (Object)publishEvent.getCreateTime()).build();
        byte[] eventBuff = publishEvent instanceof CompensatePublishEvent ? ((String)((CompensatePublishEvent)publishEvent).getEventData()).getBytes(Charsets.UTF_8) : this.serializer.serialize(publishEvent.getEventData()).getBytes(Charsets.UTF_8);
        return MessageBuilder.withBody((byte[])eventBuff).andProperties(messageProperties).build();
    }

    public PublishEvent decode(Message message, Class<?> eventDataClass) {
        MessageProperties messageProperties = message.getMessageProperties();
        Long eventId = (Long)messageProperties.getHeader(EVENT_ID);
        Preconditions.checkNotNull((Object)eventId, (String)"%s can not be null.", (Object)EVENT_ID);
        String eventName = (String)messageProperties.getHeader(EVENT_NAME);
        Preconditions.checkNotNull((Object)eventName, (String)"%s can not be null.", (Object)EVENT_NAME);
        Long eventCreateTime = (Long)messageProperties.getHeader(EVENT_CREATE_TIME);
        Preconditions.checkNotNull((Object)eventCreateTime, (String)"%s can not be null.", (Object)EVENT_CREATE_TIME);
        Object typedEventData = this.deserializer.deserialize(new String(message.getBody(), Charsets.UTF_8), eventDataClass);
        PublishEvent publishEvent = new PublishEvent();
        publishEvent.setId(eventId);
        publishEvent.setEventName(eventName);
        publishEvent.setEventData(typedEventData);
        publishEvent.setCreateTime(eventCreateTime);
        return publishEvent;
    }
}

