/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.eventbus.rabbit;

import com.google.common.base.Charsets;
import me.ahoo.eventbus.core.publisher.PublishEvent;
import me.ahoo.eventbus.core.subscriber.Subscriber;
import me.ahoo.eventbus.rabbit.RabbitEventCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class RabbitEventListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RabbitEventListener.class);
    private final Subscriber subscriber;
    private final RabbitEventCodec rabbitEventCodec;

    public RabbitEventListener(RabbitEventCodec rabbitEventCodec, Subscriber subscriber) {
        this.rabbitEventCodec = rabbitEventCodec;
        this.subscriber = subscriber;
    }

    public void onMessage(Message message) {
        block3: {
            try {
                PublishEvent publishEvent = this.rabbitEventCodec.decode(message, this.subscriber.getSubscribeEventClass());
                if (log.isInfoEnabled()) {
                    log.info("onMessage - received event subscriber:[{}]-> id:[{}] ,eventName:[{}].", new Object[]{this.subscriber.getName(), publishEvent.getId(), publishEvent.getEventName()});
                }
                this.subscriber.invoke(publishEvent);
            }
            catch (Throwable throwable) {
                String payloadStr = new String(message.getBody(), Charsets.UTF_8);
                if (!log.isErrorEnabled()) break block3;
                log.error(String.format("onMessage - received event ERROR -> routeKey:[%s] , payload: %n  %s", this.subscriber.getSubscribeEventName(), payloadStr), throwable);
            }
        }
    }
}

