/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.config;

import com.google.common.base.Strings;
import me.ahoo.govern.config.ConfigVersion;
import me.ahoo.govern.config.NamespacedConfigId;

public final class ConfigKeyGenerator {
    private static final String CONFIG_IDX = "cfg_idx";
    private static final String CONFIG_HISTORY_IDX = "cfg_htr_idx";
    private static final String CONFIG_HISTORY = "cfg_htr";
    private static final String CONFIG = "cfg";
    private static final String configIdxKeyFormat = "%s:cfg_idx";
    private static final String configHistoryIdxKeyFormat = "%s:cfg_htr_idx:%s";
    private static final String configHistoryKeyPrefixFormat = "%s:cfg_htr:";
    private static final String configHistoryKeyFormat = "%s:cfg_htr:%s:%s";
    private static final String configKeyPrefixFormat = "%s:cfg:";
    private static final String configKeyFormat = "%s:cfg:%s";

    private ConfigKeyGenerator() {
    }

    public static String getConfigIdxKey(String namespace) {
        return namespace + ":" + CONFIG_IDX;
    }

    public static String getConfigHistoryIdxKey(String namespace, String configId) {
        return Strings.lenientFormat((String)configHistoryIdxKeyFormat, (Object[])new Object[]{namespace, configId});
    }

    public static String getConfigHistoryKey(String namespace, String configId, Integer version) {
        return Strings.lenientFormat((String)configHistoryKeyFormat, (Object[])new Object[]{namespace, configId, version});
    }

    public static String getConfigKey(String namespace, String configId) {
        return Strings.lenientFormat((String)configKeyFormat, (Object[])new Object[]{namespace, configId});
    }

    public static NamespacedConfigId getConfigIdOfKey(String configKey) {
        int firstSplitIdx = configKey.indexOf(":");
        String namespace = configKey.substring(0, firstSplitIdx);
        String configKeyPrefix = Strings.lenientFormat((String)configKeyPrefixFormat, (Object[])new Object[]{namespace});
        String configId = configKey.substring(configKeyPrefix.length());
        return NamespacedConfigId.of(namespace, configId);
    }

    public static ConfigVersion getConfigVersionOfHistoryKey(String namespace, String configHistoryKey) {
        String configHistoryKeyPrefix = Strings.lenientFormat((String)configHistoryKeyPrefixFormat, (Object[])new Object[]{namespace});
        String configIdWithVersion = configHistoryKey.substring(configHistoryKeyPrefix.length());
        String[] configIdWithVersionSplit = configIdWithVersion.split(":");
        if (configIdWithVersionSplit.length != 2) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"configHistoryKey:[%s] format error.", (Object[])new Object[]{configHistoryKey}));
        }
        ConfigVersion configVersion = new ConfigVersion();
        configVersion.setConfigId(configIdWithVersionSplit[0]);
        configVersion.setVersion(Integer.parseInt(configIdWithVersionSplit[1]));
        return configVersion;
    }
}

