/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.config.redis;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.ahoo.govern.config.Config;
import me.ahoo.govern.config.ConfigChangedListener;
import me.ahoo.govern.config.ConfigHistory;
import me.ahoo.govern.config.ConfigKeyGenerator;
import me.ahoo.govern.config.ConfigListenable;
import me.ahoo.govern.config.ConfigService;
import me.ahoo.govern.config.ConfigVersion;
import me.ahoo.govern.config.NamespacedConfigId;
import me.ahoo.govern.core.NamespacedContext;
import me.ahoo.govern.core.listener.ChannelTopic;
import me.ahoo.govern.core.listener.MessageListenable;
import me.ahoo.govern.core.listener.MessageListener;
import me.ahoo.govern.core.listener.Topic;
import me.ahoo.govern.core.util.RedisKeySpaces;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyRedisConfigService
implements ConfigService,
ConfigListenable {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyRedisConfigService.class);
    private final ConfigService delegate;
    private final MessageListenable messageListenable;
    private final ConfigListener configListener;
    private final ConcurrentHashMap<NamespacedConfigId, CompletableFuture<Config>> configMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<NamespacedConfigId, ConfigChangedListener> configMapListener = new ConcurrentHashMap();

    public ConsistencyRedisConfigService(ConfigService delegate, MessageListenable messageListenable) {
        this.delegate = delegate;
        this.messageListenable = messageListenable;
        this.configListener = new ConfigListener();
    }

    @Override
    public CompletableFuture<Set<String>> getConfigs() {
        return this.delegate.getConfigs();
    }

    @Override
    public CompletableFuture<Set<String>> getConfigs(String namespace) {
        return this.delegate.getConfigs(namespace);
    }

    @Override
    public CompletableFuture<Config> getConfig(String configId) {
        return this.getConfig(NamespacedContext.GLOBAL.getNamespace(), configId);
    }

    @Override
    public CompletableFuture<Config> getConfig(String namespace, String configId) {
        return this.configMap.computeIfAbsent(NamespacedConfigId.of(namespace, configId), _configId -> this.addListener(namespace, configId).thenCompose(nil -> this.delegate.getConfig(namespace, configId)));
    }

    private CompletableFuture<Void> addListener(String namespace, String configId) {
        String topicStr = RedisKeySpaces.getTopicOfKey((String)ConfigKeyGenerator.getConfigKey(namespace, configId));
        ChannelTopic configTopic = ChannelTopic.of((String)topicStr);
        return this.messageListenable.addListener((Topic)configTopic, (MessageListener)this.configListener);
    }

    @Override
    public CompletableFuture<Boolean> setConfig(String configId, String data) {
        return this.delegate.setConfig(configId, data);
    }

    @Override
    public CompletableFuture<Boolean> setConfig(String namespace, String configId, String data) {
        return this.delegate.setConfig(namespace, configId, data);
    }

    @Override
    public CompletableFuture<Boolean> removeConfig(String configId) {
        return this.delegate.removeConfig(configId);
    }

    @Override
    public CompletableFuture<Boolean> removeConfig(String namespace, String configId) {
        return this.delegate.removeConfig(namespace, configId);
    }

    @Override
    public CompletableFuture<Boolean> addListener(String configId, ConfigChangedListener configChangedListener) {
        return this.addListener(NamespacedContext.GLOBAL.getNamespace(), configId, configChangedListener);
    }

    @Override
    public CompletableFuture<Boolean> addListener(String namespace, String configId, ConfigChangedListener configChangedListener) {
        boolean putOk = this.configMapListener.putIfAbsent(NamespacedConfigId.of(namespace, configId), configChangedListener) == null;
        return CompletableFuture.completedFuture(putOk);
    }

    @Override
    public CompletableFuture<Boolean> removeListener(String configId) {
        return this.removeListener(NamespacedContext.GLOBAL.getNamespace(), configId);
    }

    @Override
    public CompletableFuture<Boolean> removeListener(String namespace, String configId) {
        boolean removeOk = this.configMapListener.remove(NamespacedConfigId.of(namespace, configId)) != null;
        return CompletableFuture.completedFuture(removeOk);
    }

    @Override
    public CompletableFuture<Boolean> rollback(String configId, int targetVersion) {
        return this.delegate.rollback(configId, targetVersion);
    }

    @Override
    public CompletableFuture<Boolean> rollback(String namespace, String configId, int targetVersion) {
        return this.delegate.rollback(namespace, configId, targetVersion);
    }

    @Override
    public CompletableFuture<List<ConfigVersion>> getConfigVersions(String configId) {
        return this.delegate.getConfigVersions(configId);
    }

    @Override
    public CompletableFuture<List<ConfigVersion>> getConfigVersions(String namespace, String configId) {
        return this.delegate.getConfigVersions(namespace, configId);
    }

    @Override
    public CompletableFuture<ConfigHistory> getConfigHistory(String configId, int version) {
        return this.delegate.getConfigHistory(configId, version);
    }

    @Override
    public CompletableFuture<ConfigHistory> getConfigHistory(String namespace, String configId, int version) {
        return this.delegate.getConfigHistory(namespace, configId, version);
    }

    private class ConfigListener
    implements MessageListener {
        private ConfigListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@ConfigListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            String key = RedisKeySpaces.getKeyOfChannel((String)channel);
            NamespacedConfigId namespacedConfigId = ConfigKeyGenerator.getConfigIdOfKey(key);
            ConsistencyRedisConfigService.this.configMap.put(namespacedConfigId, ConsistencyRedisConfigService.this.delegate.getConfig(namespacedConfigId.getNamespace(), namespacedConfigId.getConfigId()));
            ConfigChangedListener configChangedListener = (ConfigChangedListener)ConsistencyRedisConfigService.this.configMapListener.get(namespacedConfigId);
            if (Objects.isNull(configChangedListener)) {
                return;
            }
            configChangedListener.onChange(namespacedConfigId, message);
        }
    }
}

