/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.config.redis;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.hash.Hashing;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.ahoo.govern.config.Config;
import me.ahoo.govern.config.ConfigCodec;
import me.ahoo.govern.config.ConfigHistory;
import me.ahoo.govern.config.ConfigKeyGenerator;
import me.ahoo.govern.config.ConfigService;
import me.ahoo.govern.config.ConfigVersion;
import me.ahoo.govern.config.redis.ConfigRedisScripts;
import me.ahoo.govern.core.NamespacedContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisConfigService
implements ConfigService {
    private static final Logger log = LoggerFactory.getLogger(RedisConfigService.class);
    private final RedisClusterAsyncCommands<String, String> redisCommands;
    private static final int HISTORY_STOP = 9;

    public RedisConfigService(RedisClusterAsyncCommands<String, String> redisCommands) {
        this.redisCommands = redisCommands;
    }

    @Override
    public CompletableFuture<Set<String>> getConfigs() {
        return this.getConfigs(NamespacedContext.GLOBAL.getNamespace());
    }

    @Override
    public CompletableFuture<Set<String>> getConfigs(String namespace) {
        if (log.isInfoEnabled()) {
            log.info("getConfigs  @ namespace:[{}].", (Object)namespace);
        }
        String configIdxKey = ConfigKeyGenerator.getConfigIdxKey(namespace);
        return this.redisCommands.smembers((Object)configIdxKey).thenApply(configKeySet -> configKeySet.stream().map(configKey -> ConfigKeyGenerator.getConfigIdOfKey(configKey).getConfigId()).collect(Collectors.toSet())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<Config> getConfig(String configId) {
        return this.getConfig(NamespacedContext.GLOBAL.getNamespace(), configId);
    }

    @Override
    public CompletableFuture<Config> getConfig(String namespace, String configId) {
        if (log.isInfoEnabled()) {
            log.info("getConfig - configId:[{}]  @ namespace:[{}].", (Object)configId, (Object)namespace);
        }
        String configKey = ConfigKeyGenerator.getConfigKey(namespace, configId);
        return this.getAndDecodeConfig(configKey, ConfigCodec::decode);
    }

    @Override
    public CompletableFuture<Boolean> setConfig(String configId, String data) {
        return this.setConfig(NamespacedContext.GLOBAL.getNamespace(), configId, data);
    }

    @Override
    public CompletableFuture<Boolean> setConfig(String namespace, String configId, String data) {
        String hash = Hashing.sha256().hashString((CharSequence)data, Charsets.UTF_8).toString();
        if (log.isInfoEnabled()) {
            log.info("setConfig - configId:[{}] - hash:[{}]  @ namespace:[{}].", new Object[]{configId, hash, namespace});
        }
        return ConfigRedisScripts.loadConfigSet(this.redisCommands).thenCompose(sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{configId, data, hash};
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values);
            return redisFuture;
        });
    }

    @Override
    public CompletableFuture<Boolean> removeConfig(String configId) {
        return this.removeConfig(NamespacedContext.GLOBAL.getNamespace(), configId);
    }

    @Override
    public CompletableFuture<Boolean> removeConfig(String namespace, String configId) {
        if (log.isInfoEnabled()) {
            log.info("removeConfig - configId:[{}] @ namespace:[{}].", (Object)configId, (Object)namespace);
        }
        return ConfigRedisScripts.loadConfigRemove(this.redisCommands).thenCompose(sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{configId};
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values);
            return redisFuture;
        });
    }

    @Override
    public CompletableFuture<Boolean> rollback(String configId, int targetVersion) {
        return this.rollback(NamespacedContext.GLOBAL.getNamespace(), configId, targetVersion);
    }

    @Override
    public CompletableFuture<Boolean> rollback(String namespace, String configId, int targetVersion) {
        if (log.isInfoEnabled()) {
            log.info("rollback - configId:[{}] - targetVersion:[{}]  @ namespace:[{}].", new Object[]{configId, targetVersion, namespace});
        }
        return ConfigRedisScripts.loadConfigRollback(this.redisCommands).thenCompose(sha -> {
            Object[] keys = new String[]{namespace};
            Object[] values = new String[]{configId, String.valueOf(targetVersion)};
            RedisFuture redisFuture = this.redisCommands.evalsha(sha, ScriptOutputType.BOOLEAN, keys, values);
            return redisFuture;
        });
    }

    @Override
    public CompletableFuture<List<ConfigVersion>> getConfigVersions(String configId) {
        return this.getConfigVersions(NamespacedContext.GLOBAL.getNamespace(), configId);
    }

    @Override
    public CompletableFuture<List<ConfigVersion>> getConfigVersions(String namespace, String configId) {
        String configHistoryIdxKey = ConfigKeyGenerator.getConfigHistoryIdxKey(namespace, configId);
        return this.redisCommands.zrevrange((Object)configHistoryIdxKey, 0L, 9L).thenApply(configHistoryKeyList -> configHistoryKeyList.stream().map(configHistoryKey -> ConfigKeyGenerator.getConfigVersionOfHistoryKey(namespace, configHistoryKey)).collect(Collectors.toList())).toCompletableFuture();
    }

    @Override
    public CompletableFuture<ConfigHistory> getConfigHistory(String configId, int version) {
        return this.getConfigHistory(NamespacedContext.GLOBAL.getNamespace(), configId, version);
    }

    @Override
    public CompletableFuture<ConfigHistory> getConfigHistory(String namespace, String configId, int version) {
        String configHistoryKey = ConfigKeyGenerator.getConfigHistoryKey(namespace, configId, version);
        return this.getAndDecodeConfig(configHistoryKey, ConfigCodec::decodeHistory);
    }

    private <T extends Config> CompletableFuture<T> getAndDecodeConfig(String configHistoryKey, Function<Map<String, String>, T> decodeFun) {
        return this.redisCommands.hgetall((Object)configHistoryKey).thenApply(configData -> {
            if (configData.isEmpty()) {
                return null;
            }
            return (Config)decodeFun.apply(configData);
        }).toCompletableFuture();
    }
}

