/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery;

import com.google.common.base.Strings;
import me.ahoo.govern.core.Namespaced;

public class DiscoveryKeyGenerator
implements Namespaced {
    private static final String SERVICE_IDX = "svc_idx";
    private static final String SERVICE_INSTANCE_IDX = "svc_itc_idx";
    private static final String SERVICE_INSTANCE = "svc_itc";
    private final String namespace;
    private final String serviceIdxKey;
    private final String instanceIdxKeyFormat;
    private final String instanceKeyFormat;
    private final String instanceKeyPrefix;
    private final String instanceKeyPatternOfServiceFormat;

    public DiscoveryKeyGenerator(String namespace) {
        this.namespace = namespace;
        this.serviceIdxKey = namespace + ":" + SERVICE_IDX;
        this.instanceIdxKeyFormat = namespace + ":" + SERVICE_INSTANCE_IDX + ":%s";
        this.instanceKeyFormat = namespace + ":" + SERVICE_INSTANCE + ":%s";
        this.instanceKeyPrefix = namespace + ":svc_itc:";
        this.instanceKeyPatternOfServiceFormat = this.instanceKeyPrefix + "%s@*";
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceIdxKey() {
        return this.serviceIdxKey;
    }

    public String getInstanceIdxKey(String serviceId) {
        return Strings.lenientFormat((String)this.instanceIdxKeyFormat, (Object[])new Object[]{serviceId});
    }

    public String getInstanceKey(String instanceId) {
        return Strings.lenientFormat((String)this.instanceKeyFormat, (Object[])new Object[]{instanceId});
    }

    public String getInstanceKeyPatternOfService(String serviceId) {
        return Strings.lenientFormat((String)this.instanceKeyPatternOfServiceFormat, (Object[])new Object[]{serviceId});
    }

    public String getInstanceIdOfKey(String instanceKey) {
        return instanceKey.substring(this.instanceKeyPrefix.length());
    }
}

