/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery.redis;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import me.ahoo.govern.core.listener.ChannelTopic;
import me.ahoo.govern.core.listener.MessageListenable;
import me.ahoo.govern.core.listener.MessageListener;
import me.ahoo.govern.core.listener.PatternTopic;
import me.ahoo.govern.core.listener.Topic;
import me.ahoo.govern.core.util.RedisKeySpaces;
import me.ahoo.govern.discovery.DiscoveryKeyGenerator;
import me.ahoo.govern.discovery.Instance;
import me.ahoo.govern.discovery.InstanceIdGenerator;
import me.ahoo.govern.discovery.ServiceDiscovery;
import me.ahoo.govern.discovery.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyRedisServiceDiscovery
implements ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ConsistencyRedisServiceDiscovery.class);
    private final ServiceDiscovery delegate;
    private final MessageListenable messageListenable;
    private final ServiceIdxListener serviceIdxListener;
    private final InstanceListener instanceListener;
    private final DiscoveryKeyGenerator keyGenerator;
    private final Topic serviceIdxTopic;
    private final ConcurrentHashMap<String, CompletableFuture<List<ServiceInstance>>> serviceMapInstances;
    private volatile CompletableFuture<Set<String>> servicesFuture = null;

    public ConsistencyRedisServiceDiscovery(DiscoveryKeyGenerator keyGenerator, ServiceDiscovery delegate, MessageListenable messageListenable) {
        String topicStr = RedisKeySpaces.getTopicOfKey((String)keyGenerator.getServiceIdxKey());
        this.serviceIdxTopic = ChannelTopic.of((String)topicStr);
        this.keyGenerator = keyGenerator;
        this.serviceMapInstances = new ConcurrentHashMap();
        this.delegate = delegate;
        this.messageListenable = messageListenable;
        this.serviceIdxListener = new ServiceIdxListener();
        this.instanceListener = new InstanceListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Set<String>> getServices() {
        if (Objects.nonNull(this.servicesFuture)) {
            return this.servicesFuture;
        }
        ConsistencyRedisServiceDiscovery consistencyRedisServiceDiscovery = this;
        synchronized (consistencyRedisServiceDiscovery) {
            if (Objects.nonNull(this.servicesFuture)) {
                return this.servicesFuture;
            }
            this.servicesFuture = this.messageListenable.addListener(this.serviceIdxTopic, (MessageListener)this.serviceIdxListener).thenCompose(nil -> {
                this.servicesFuture = this.delegate.getServices();
                return this.servicesFuture;
            });
        }
        return this.servicesFuture;
    }

    @Override
    public CompletableFuture<List<ServiceInstance>> getInstances(String serviceId) {
        return this.serviceMapInstances.computeIfAbsent(serviceId, _serviceId -> this.addListener(serviceId).thenCompose(nil -> this.delegate.getInstances(serviceId)));
    }

    @VisibleForTesting
    public CompletableFuture<Void> addListener(String serviceId) {
        PatternTopic instanceTopic = this.getPatternTopic(serviceId);
        return this.messageListenable.addListener((Topic)instanceTopic, (MessageListener)this.instanceListener);
    }

    @VisibleForTesting
    public Future<Void> removeListener(String serviceId) {
        PatternTopic instanceTopic = this.getPatternTopic(serviceId);
        return this.messageListenable.removeListener((Topic)instanceTopic);
    }

    private PatternTopic getPatternTopic(String serviceId) {
        String instancePattern = this.keyGenerator.getInstanceKeyPatternOfService(serviceId);
        String topicStr = RedisKeySpaces.getTopicOfKey((String)instancePattern);
        PatternTopic instanceTopic = PatternTopic.of((String)topicStr);
        return instanceTopic;
    }

    private class InstanceListener
    implements MessageListener {
        private static final String MSG_EXPIRE = "expire";

        private InstanceListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@InstanceListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            if (MSG_EXPIRE.equals(message)) {
                return;
            }
            String key = RedisKeySpaces.getKeyOfChannel((String)channel);
            String instanceId = ConsistencyRedisServiceDiscovery.this.keyGenerator.getInstanceIdOfKey(key);
            Instance instance = InstanceIdGenerator.DEFAULT.of(instanceId);
            String serviceId = instance.getServiceId();
            ConsistencyRedisServiceDiscovery.this.serviceMapInstances.put(serviceId, ConsistencyRedisServiceDiscovery.this.delegate.getInstances(serviceId));
        }
    }

    private class ServiceIdxListener
    implements MessageListener {
        private ServiceIdxListener() {
        }

        public void onMessage(Topic topic, String channel, String message) {
            if (log.isInfoEnabled()) {
                log.info("onMessage@ServiceIdxListener - topic:[{}] - channel:[{}] - message:[{}]", new Object[]{topic, channel, message});
            }
            ConsistencyRedisServiceDiscovery.this.servicesFuture = ConsistencyRedisServiceDiscovery.this.delegate.getServices();
        }
    }
}

