/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.discovery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ahoo.govern.discovery.ServiceInstance;

public final class ServiceInstanceCodec {
    private static final String SYSTEM_METADATA_PREFIX = "__";
    private static final String METADATA_PREFIX = "_";
    private static final int METADATA_PREFIX_LENGTH = "_".length();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String INSTANCE_ID = "instanceId";
    private static final String SERVICE_ID = "serviceId";
    private static final String SCHEMA = "schema";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String WEIGHT = "weight";
    private static final String EPHEMERAL = "ephemeral";
    private static final String TTL_AT = "ttl_at";

    @Deprecated
    public static Map<String, String> encode(ServiceInstance serviceInstance) {
        HashMap<String, String> serviceInstanceData = new HashMap<String, String>();
        serviceInstanceData.put(INSTANCE_ID, serviceInstance.getInstanceId());
        serviceInstanceData.put(SERVICE_ID, serviceInstance.getServiceId());
        serviceInstanceData.put(SCHEMA, serviceInstance.getSchema());
        serviceInstanceData.put(IP, serviceInstance.getIp());
        serviceInstanceData.put(PORT, String.valueOf(serviceInstance.getPort()));
        serviceInstanceData.put(WEIGHT, String.valueOf(serviceInstance.getWeight()));
        serviceInstanceData.put(EPHEMERAL, String.valueOf(serviceInstance.isEphemeral()));
        serviceInstance.getMetadata().forEach((key, value) -> {
            String metadataKey = METADATA_PREFIX + key;
            serviceInstanceData.put(metadataKey, (String)value);
        });
        return serviceInstanceData;
    }

    public static String[] encodeMetadata(String[] preArgs, Map<String, String> instanceMetadata) {
        if (instanceMetadata.isEmpty()) {
            return preArgs;
        }
        String[] values = new String[preArgs.length + instanceMetadata.size() * 2];
        System.arraycopy(preArgs, 0, values, 0, preArgs.length);
        int valueIdx = preArgs.length - 1;
        for (Map.Entry<String, String> metadataKV : instanceMetadata.entrySet()) {
            values[++valueIdx] = METADATA_PREFIX + metadataKV.getKey();
            values[++valueIdx] = metadataKV.getValue();
        }
        return values;
    }

    public static ServiceInstance decode(List<String> instanceData) {
        ServiceInstance serviceInstance = new ServiceInstance();
        block20: for (int i = 0; i < instanceData.size(); i += 2) {
            String key = instanceData.get(i);
            String value = instanceData.get(i + 1);
            switch (key) {
                case "instanceId": {
                    serviceInstance.setInstanceId(value);
                    continue block20;
                }
                case "serviceId": {
                    serviceInstance.setServiceId(value);
                    continue block20;
                }
                case "schema": {
                    serviceInstance.setSchema(value);
                    continue block20;
                }
                case "ip": {
                    serviceInstance.setIp(value);
                    continue block20;
                }
                case "port": {
                    serviceInstance.setPort(Integer.parseInt(value));
                    continue block20;
                }
                case "weight": {
                    serviceInstance.setWeight(Integer.parseInt(value));
                    continue block20;
                }
                case "ephemeral": {
                    serviceInstance.setEphemeral(Boolean.parseBoolean(value));
                    continue block20;
                }
                case "ttl_at": {
                    serviceInstance.setTtlAt(Integer.parseInt(value));
                    continue block20;
                }
                default: {
                    if (key.startsWith(SYSTEM_METADATA_PREFIX) || !key.startsWith(METADATA_PREFIX)) continue block20;
                    String metadataKey = key.substring(METADATA_PREFIX_LENGTH);
                    serviceInstance.getMetadata().put(metadataKey, value);
                }
            }
        }
        return serviceInstance;
    }

    @Deprecated
    public static ServiceInstance decode(Map<String, String> instanceData) {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setInstanceId(instanceData.get(INSTANCE_ID));
        serviceInstance.setServiceId(instanceData.get(SERVICE_ID));
        serviceInstance.setSchema(instanceData.get(SCHEMA));
        serviceInstance.setIp(instanceData.get(IP));
        serviceInstance.setPort(Integer.parseInt(instanceData.get(PORT)));
        serviceInstance.setWeight(Integer.parseInt(instanceData.get(WEIGHT)));
        serviceInstance.setEphemeral(Boolean.parseBoolean(instanceData.get(EPHEMERAL)));
        if (instanceData.containsKey(TTL_AT)) {
            serviceInstance.setTtlAt(Integer.parseInt(instanceData.get(TTL_AT)));
        }
        instanceData.forEach((key, value) -> {
            if (key.startsWith(METADATA_PREFIX)) {
                String metadataKey = key.substring(METADATA_PREFIX_LENGTH);
                serviceInstance.getMetadata().put(metadataKey, (String)value);
            }
        });
        return serviceInstance;
    }
}

