/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.govern.core.listener;

import java.util.concurrent.CompletableFuture;
import me.ahoo.govern.core.listener.MessageListener;
import me.ahoo.govern.core.listener.Topic;
import org.slf4j.LoggerFactory;

public interface MessageListenable
extends AutoCloseable {
    public static final MessageListenable NULL = new Logger();

    public CompletableFuture<Void> addListener(Topic var1, MessageListener var2);

    public CompletableFuture<Void> removeListener(Topic var1, MessageListener var2);

    public static class Logger
    implements MessageListenable {
        private static final org.slf4j.Logger log = LoggerFactory.getLogger(Logger.class);

        @Override
        public CompletableFuture<Void> addListener(Topic topic, MessageListener messageListener) {
            log.info("addListener - topic:[{}].", (Object)topic);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> removeListener(Topic topic, MessageListener messageListener) {
            log.info("removeListener - topic:[{}].", (Object)topic);
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void close() throws Exception {
        }
    }
}

